/*
 * Decompiled with CFR 0.152.
 */
package com.binance.api.client.domain.account;

import com.binance.api.client.constant.BinanceApiConstants;
import com.binance.api.client.domain.account.MarginAssetBalance;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;

@JsonIgnoreProperties
public class MarginAccount {
    private boolean borrowEnabled;
    private String marginLevel;
    private String totalAssetOfBtc;
    private String totalLiabilityOfBtc;
    private String totalNetAssetOfBtc;
    private boolean tradeEnabled;
    private boolean transferEnabled;
    private List<MarginAssetBalance> userAssets;

    public boolean isBorrowEnabled() {
        return this.borrowEnabled;
    }

    public void setBorrowEnabled(boolean borrowEnabled) {
        this.borrowEnabled = borrowEnabled;
    }

    public String getMarginLevel() {
        return this.marginLevel;
    }

    public void setMarginLevel(String marginLevel) {
        this.marginLevel = marginLevel;
    }

    public String getTotalAssetOfBtc() {
        return this.totalAssetOfBtc;
    }

    public void setTotalAssetOfBtc(String totalAssetOfBtc) {
        this.totalAssetOfBtc = totalAssetOfBtc;
    }

    public String getTotalLiabilityOfBtc() {
        return this.totalLiabilityOfBtc;
    }

    public void setTotalLiabilityOfBtc(String totalLiabilityOfBtc) {
        this.totalLiabilityOfBtc = totalLiabilityOfBtc;
    }

    public String getTotalNetAssetOfBtc() {
        return this.totalNetAssetOfBtc;
    }

    public void setTotalNetAssetOfBtc(String totalNetAssetOfBtc) {
        this.totalNetAssetOfBtc = totalNetAssetOfBtc;
    }

    public boolean isTradeEnabled() {
        return this.tradeEnabled;
    }

    public void setTradeEnabled(boolean tradeEnabled) {
        this.tradeEnabled = tradeEnabled;
    }

    public boolean isTransferEnabled() {
        return this.transferEnabled;
    }

    public void setTransferEnabled(boolean transferEnabled) {
        this.transferEnabled = transferEnabled;
    }

    public List<MarginAssetBalance> getUserAssets() {
        return this.userAssets;
    }

    public void setUserAssets(List<MarginAssetBalance> userAssets) {
        this.userAssets = userAssets;
    }

    public MarginAssetBalance getAssetBalance(String symbol) {
        return this.userAssets.stream().filter(marginAssetBalance -> marginAssetBalance.getAsset().equals(symbol)).findFirst().orElse(MarginAssetBalance.of(symbol));
    }

    public String toString() {
        return new ToStringBuilder((Object)this, BinanceApiConstants.TO_STRING_BUILDER_STYLE).append("borrowEnabled", this.borrowEnabled).append("marginLevel", (Object)this.marginLevel).append("totalAssetOfBtc", (Object)this.totalAssetOfBtc).append("totalLiabilityOfBtc", (Object)this.totalLiabilityOfBtc).append("totalNetAssetOfBtc", (Object)this.totalNetAssetOfBtc).append("tradeEnabled", this.tradeEnabled).append("transferEnabled", this.transferEnabled).append("userAssets", this.userAssets).toString();
    }
}

