/*
 * Decompiled with CFR 0.152.
 */
package com.binance.api.client.impl;

import com.binance.api.client.BinanceApiAsyncMarginRestClient;
import com.binance.api.client.BinanceApiCallback;
import com.binance.api.client.domain.TransferType;
import com.binance.api.client.domain.account.MarginAccount;
import com.binance.api.client.domain.account.MarginNewOrder;
import com.binance.api.client.domain.account.MarginNewOrderResponse;
import com.binance.api.client.domain.account.MarginTransaction;
import com.binance.api.client.domain.account.Order;
import com.binance.api.client.domain.account.Trade;
import com.binance.api.client.domain.account.request.CancelOrderRequest;
import com.binance.api.client.domain.account.request.CancelOrderResponse;
import com.binance.api.client.domain.account.request.OrderRequest;
import com.binance.api.client.domain.account.request.OrderStatusRequest;
import com.binance.api.client.domain.event.ListenKey;
import com.binance.api.client.impl.BinanceApiCallbackAdapter;
import com.binance.api.client.impl.BinanceApiService;
import com.binance.api.client.impl.BinanceApiServiceGenerator;
import java.util.List;

public class BinanceApiAsyncMarginRestClientImpl
implements BinanceApiAsyncMarginRestClient {
    private final BinanceApiService binanceApiService;

    public BinanceApiAsyncMarginRestClientImpl(String apiKey, String secret) {
        this.binanceApiService = BinanceApiServiceGenerator.createService(BinanceApiService.class, apiKey, secret);
    }

    @Override
    public void getAccount(Long recvWindow, Long timestamp, BinanceApiCallback<MarginAccount> callback) {
        this.binanceApiService.getMarginAccount(recvWindow, timestamp).enqueue(new BinanceApiCallbackAdapter<MarginAccount>(callback));
    }

    @Override
    public void getAccount(BinanceApiCallback<MarginAccount> callback) {
        long timestamp = System.currentTimeMillis();
        this.binanceApiService.getMarginAccount(5000L, timestamp).enqueue(new BinanceApiCallbackAdapter<MarginAccount>(callback));
    }

    @Override
    public void getOpenOrders(OrderRequest orderRequest, BinanceApiCallback<List<Order>> callback) {
        this.binanceApiService.getOpenMarginOrders(orderRequest.getSymbol(), orderRequest.getRecvWindow(), orderRequest.getTimestamp()).enqueue(new BinanceApiCallbackAdapter<List<Order>>(callback));
    }

    @Override
    public void newOrder(MarginNewOrder order, BinanceApiCallback<MarginNewOrderResponse> callback) {
        this.binanceApiService.newMarginOrder(order.getSymbol(), order.getSide(), order.getType(), order.getTimeInForce(), order.getQuantity(), order.getPrice(), order.getNewClientOrderId(), order.getStopPrice(), order.getIcebergQty(), order.getNewOrderRespType(), order.getSideEffectType(), order.getRecvWindow(), order.getTimestamp()).enqueue(new BinanceApiCallbackAdapter<MarginNewOrderResponse>(callback));
    }

    @Override
    public void cancelOrder(CancelOrderRequest cancelOrderRequest, BinanceApiCallback<CancelOrderResponse> callback) {
        this.binanceApiService.cancelMarginOrder(cancelOrderRequest.getSymbol(), cancelOrderRequest.getOrderId(), cancelOrderRequest.getOrigClientOrderId(), cancelOrderRequest.getNewClientOrderId(), cancelOrderRequest.getRecvWindow(), cancelOrderRequest.getTimestamp()).enqueue(new BinanceApiCallbackAdapter<CancelOrderResponse>(callback));
    }

    @Override
    public void getOrderStatus(OrderStatusRequest orderStatusRequest, BinanceApiCallback<Order> callback) {
        this.binanceApiService.getMarginOrderStatus(orderStatusRequest.getSymbol(), orderStatusRequest.getOrderId(), orderStatusRequest.getOrigClientOrderId(), orderStatusRequest.getRecvWindow(), orderStatusRequest.getTimestamp()).enqueue(new BinanceApiCallbackAdapter<Order>(callback));
    }

    @Override
    public void getMyTrades(String symbol, BinanceApiCallback<List<Trade>> callback) {
        this.binanceApiService.getMyTrades(symbol, null, null, 60000L, System.currentTimeMillis()).enqueue(new BinanceApiCallbackAdapter<List<Trade>>(callback));
    }

    @Override
    public void startUserDataStream(BinanceApiCallback<ListenKey> callback) {
        this.binanceApiService.startMarginUserDataStream().enqueue(new BinanceApiCallbackAdapter<ListenKey>(callback));
    }

    @Override
    public void keepAliveUserDataStream(String listenKey, BinanceApiCallback<Void> callback) {
        this.binanceApiService.keepAliveMarginUserDataStream(listenKey).enqueue(new BinanceApiCallbackAdapter<Void>(callback));
    }

    @Override
    public void transfer(String asset, String amount, TransferType type, BinanceApiCallback<MarginTransaction> callback) {
        long timestamp = System.currentTimeMillis();
        this.binanceApiService.transfer(asset, amount, type.getValue(), 5000L, timestamp).enqueue(new BinanceApiCallbackAdapter<MarginTransaction>(callback));
    }

    @Override
    public void borrow(String asset, String amount, BinanceApiCallback<MarginTransaction> callback) {
        long timestamp = System.currentTimeMillis();
        this.binanceApiService.borrow(asset, amount, 5000L, timestamp).enqueue(new BinanceApiCallbackAdapter<MarginTransaction>(callback));
    }

    @Override
    public void repay(String asset, String amount, BinanceApiCallback<MarginTransaction> callback) {
        long timestamp = System.currentTimeMillis();
        this.binanceApiService.repay(asset, amount, 5000L, timestamp).enqueue(new BinanceApiCallbackAdapter<MarginTransaction>(callback));
    }
}

