/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.bukkitversion;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.NotNull;

public final class BukkitVersion {
    public static final BukkitVersion INSTANCE;
    public static final int MAJOR;
    public static final int MICRO;
    public static final int MINOR;
    @NotNull
    private static final Pattern PATTERN;
    @NotNull
    private final Matcher matcher;
    @NotNull
    private final String version;

    public BukkitVersion(@NotNull String version) {
        this.version = version;
        this.matcher = PATTERN.matcher(version);
    }

    public BukkitVersion() {
        this(Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3].substring(1));
    }

    public int major() {
        return this.get("major");
    }

    public int micro() {
        return this.get("micro");
    }

    public int minor() {
        return this.get("minor");
    }

    private int get(@NotNull String key) {
        return this.matcher.matches() ? Integer.parseInt(this.matcher.group(key)) : 0;
    }

    @NotNull
    public Matcher matcher() {
        return this.matcher;
    }

    @NotNull
    public String version() {
        return this.version;
    }

    static {
        PATTERN = Pattern.compile("v?(?<major>[0-9]+)[._](?<minor>[0-9]+)(?:[._]R(?<micro>[0-9]+))?(?<sub>.*)");
        INSTANCE = new BukkitVersion();
        MAJOR = INSTANCE.major();
        MICRO = INSTANCE.micro();
        MINOR = INSTANCE.minor();
    }
}

