/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.platform.velocity.kubernetes;

import com.google.common.base.Preconditions;
import com.velocitypowered.api.event.PostOrder;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.player.PlayerChooseInitialServerEvent;
import com.velocitypowered.api.event.proxy.ProxyPingEvent;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import java.util.Collection;
import java.util.Comparator;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import tr.com.infumia.infumialib.api.kubernetes.DiscoveredService;
import tr.com.infumia.infumialib.api.kubernetes.ServerRegistry;

public record LoadBalancing(@NotNull ProxyServer server, @NotNull Logger logger) {
    @Subscribe(order=PostOrder.LATE)
    public void onJoin(PlayerChooseInitialServerEvent event) {
        Set<DiscoveredService> servers = ServerRegistry.registeredDefaultServices();
        if (servers.isEmpty()) {
            return;
        }
        RegisteredServer server = this.applicableServer();
        this.logger.info("Load balancing {} to {}", (Object)event.getPlayer().getUsername(), (Object)server.getServerInfo().getName());
        event.setInitialServer(server);
    }

    @Subscribe
    public void ping(ProxyPingEvent event) {
        int playerSize = this.allServers().stream().mapToInt(value -> value.getPlayersConnected().size()).sum();
        event.setPing(event.getPing().asBuilder().onlinePlayers(playerSize).maximumPlayers(playerSize + 1).build());
    }

    @NotNull
    private Collection<RegisteredServer> allServers() {
        return ServerRegistry.registeredServices().stream().map(s -> this.server.getServer(s.name())).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
    }

    @NotNull
    private RegisteredServer applicableServer() {
        Set<DiscoveredService> services = ServerRegistry.registeredDefaultServices();
        Preconditions.checkState((!services.isEmpty() ? 1 : 0) != 0, (Object)"Any service not found!");
        return (RegisteredServer)services.stream().map(s -> this.server.getServer(s.name())).filter(Optional::isPresent).map(Optional::get).sorted(Comparator.comparingInt(one -> one.getPlayersConnected().size())).collect(Collectors.toList()).get(0);
    }
}

