/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.common.transformer.declarations;

import org.jetbrains.annotations.NotNull;
import tr.com.infumia.infumialib.common.transformer.declarations.GenericDeclaration;
import tr.com.infumia.infumialib.common.transformer.declarations.GenericPair;

public interface GenericHolder<L, R> {
    @NotNull
    public static <L, R> GenericHolder<L, R> create(@NotNull Class<L> left, @NotNull Class<R> right) {
        return GenericHolder.create(GenericDeclaration.ofReady(left), GenericDeclaration.ofReady(right));
    }

    @NotNull
    public static <L, R> GenericHolder<L, R> create(@NotNull GenericDeclaration left, @NotNull GenericDeclaration right) {
        return new Impl(left, right);
    }

    @NotNull
    public GenericDeclaration getLeftType();

    @NotNull
    default public GenericPair getPair() {
        return GenericPair.of(this.getLeftType(), this.getRightType());
    }

    @NotNull
    public GenericDeclaration getRightType();

    public static final class Impl<L, R>
    implements GenericHolder<L, R> {
        @NotNull
        private final GenericDeclaration leftType;
        @NotNull
        private final GenericDeclaration rightType;

        @Override
        @NotNull
        public GenericDeclaration getLeftType() {
            return this.leftType;
        }

        @Override
        @NotNull
        public GenericDeclaration getRightType() {
            return this.rightType;
        }

        private Impl(@NotNull GenericDeclaration leftType, @NotNull GenericDeclaration rightType) {
            if (leftType == null) {
                throw new NullPointerException("leftType is marked non-null but is null");
            }
            if (rightType == null) {
                throw new NullPointerException("rightType is marked non-null but is null");
            }
            this.leftType = leftType;
            this.rightType = rightType;
        }
    }
}

