/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.common.registries;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.infumialib.api.definitions.Definition;

public final class IntRegistry<V extends Definition.IntKey> {
    private final Int2ObjectMap<V> values = new Int2ObjectOpenHashMap();

    @NotNull
    public Optional<V> get(int key) {
        return Optional.ofNullable((Definition.IntKey)this.values.get(key));
    }

    @NotNull
    public Int2ObjectMap<V> getValues() {
        return Int2ObjectMaps.unmodifiable(this.values);
    }

    public void register(@NotNull V value) {
        this.values.put(value.key(), value);
    }

    public void unregister(@NotNull V value) {
        this.unregister(value.key());
    }

    public void unregister(int key) {
        this.values.remove(key);
    }
}

