/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.misc;

import com.google.common.base.Preconditions;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

public interface TypeParameterMatcher
extends Predicate<Object> {
    @NotNull
    public static TypeParameterMatcher of(@NotNull Object object, @NotNull Class<?> parametrizedSuperclass, @NotNull String typeParamName) {
        return TypeParameterMatcher.of(TypeParameterMatcher.find(object, parametrizedSuperclass, typeParamName));
    }

    @NotNull
    public static Class<?> find(@NotNull Object object, @NotNull Class<?> parametrizedSuperclass, @NotNull String typeParamName) {
        Class<?> thisClass;
        block10: {
            Class<?> currentClass = thisClass = object.getClass();
            while (true) {
                if (currentClass.getSuperclass() != parametrizedSuperclass) {
                    Preconditions.checkState(((currentClass = currentClass.getSuperclass()) != null ? 1 : 0) != 0, (String)"cannot determine the type of the type parameter '%s': %s", (Object)typeParamName, thisClass);
                    continue;
                }
                int typeParamIndex = -1;
                TypeVariable<Class<?>>[] typeParams = currentClass.getSuperclass().getTypeParameters();
                for (int i = 0; i < typeParams.length; ++i) {
                    if (!typeParamName.equals(typeParams[i].getName())) continue;
                    typeParamIndex = i;
                    break;
                }
                Preconditions.checkState((typeParamIndex >= 0 ? 1 : 0) != 0, (String)"unknown type parameter '%s': %s", (Object)typeParamName, parametrizedSuperclass);
                Type genericSuperType = currentClass.getGenericSuperclass();
                if (!(genericSuperType instanceof ParameterizedType)) {
                    return Object.class;
                }
                ParameterizedType parameterizedType = (ParameterizedType)genericSuperType;
                Type[] actualTypeParams = parameterizedType.getActualTypeArguments();
                Type actualTypeParam = actualTypeParams[typeParamIndex];
                if (actualTypeParam instanceof ParameterizedType) {
                    ParameterizedType type = (ParameterizedType)actualTypeParam;
                    actualTypeParam = type.getRawType();
                }
                if (actualTypeParam instanceof Class) {
                    Class cls = (Class)actualTypeParam;
                    return cls;
                }
                if (actualTypeParam instanceof GenericArrayType) {
                    Type type;
                    GenericArrayType arrayType = (GenericArrayType)actualTypeParam;
                    Type componentType = arrayType.getGenericComponentType();
                    if (componentType instanceof ParameterizedType) {
                        type = (ParameterizedType)componentType;
                        componentType = type.getRawType();
                    }
                    if (componentType instanceof Class) {
                        type = (Class)componentType;
                        return Array.newInstance(type, 0).getClass();
                    }
                }
                if (!(actualTypeParam instanceof TypeVariable)) break block10;
                TypeVariable v = (TypeVariable)actualTypeParam;
                if (!(v.getGenericDeclaration() instanceof Class)) {
                    return Object.class;
                }
                currentClass = thisClass;
                parametrizedSuperclass = (Class)v.getGenericDeclaration();
                typeParamName = v.getName();
                if (!parametrizedSuperclass.isAssignableFrom(thisClass)) break;
            }
            return Object.class;
        }
        throw new IllegalStateException("cannot determine the type of the type parameter '" + typeParamName + "': " + thisClass);
    }

    @NotNull
    private static TypeParameterMatcher of(Class<?> parameterType) {
        return parameterType == Object.class ? msg -> true : parameterType::isInstance;
    }
}

