/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.messaging;

import com.google.protobuf.ByteString;
import java.util.Optional;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tr.com.infumia.infumialib.definition.Definition;
import tr.com.infumia.infumialib.messaging.Teleport;
import tr.com.infumia.infumialib.messaging.Travel;
import tr.com.infumia.infumialib.messaging.errors.BooleanResult;
import tr.com.infumia.infumialib.messaging.errors.PositionResult;
import tr.com.infumia.infumialib.proto.Definitions;
import tr.com.infumia.infumialib.proto.Messaging;
import tr.com.infumia.infumialib.registries.Registry;

public interface Portal
extends Definition.TeleportHolder,
Definition.TravelHolder,
Definition.BytesSerializer<String>,
Definition.Key<String>,
Definition.Type {
    public static final Registry<String, Portal> PORTALS = new Registry();

    @NotNull
    public static Optional<Portal> get(@NotNull String key) {
        return PORTALS.get(key);
    }

    public static void register(@NotNull Portal portal) {
        PORTALS.register(portal);
    }

    @NotNull
    default public Optional<Messaging.Travel.Request> createRequest(@NotNull Definitions.OfflineUser source, @NotNull String value) {
        Optional serialize = this.serialize(value);
        if (serialize.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(Messaging.Travel.Request.newBuilder().setSource(source).setType(this.type()).setValue(ByteString.copyFrom((byte[])((byte[])serialize.get()))).build());
    }

    @Override
    @NotNull
    default public String key() {
        return this.type();
    }

    @NotNull
    public PositionResult onRequest(@NotNull Definitions.OfflineUser var1, @NotNull String var2);

    @NotNull
    public BooleanResult sendRequest(@NotNull Definitions.OfflineUser var1, @NotNull String var2, @NotNull Supplier<@Nullable Definitions.Error> var3);

    public boolean whenLogin();

    public static abstract class Base
    implements Portal {
        @NotNull
        private final Teleport teleport;
        @NotNull
        private final Travel travel;
        @NotNull
        private final String type;
        private final boolean whenLogin;

        @Override
        @NotNull
        public Teleport teleport() {
            return this.teleport;
        }

        @Override
        @NotNull
        public Travel travel() {
            return this.travel;
        }

        @Override
        @NotNull
        public String type() {
            return this.type;
        }

        @Override
        public boolean whenLogin() {
            return this.whenLogin;
        }

        protected Base(@NotNull Teleport teleport, @NotNull Travel travel, @NotNull String type, boolean whenLogin) {
            if (teleport == null) {
                throw new NullPointerException("teleport is marked non-null but is null");
            }
            if (travel == null) {
                throw new NullPointerException("travel is marked non-null but is null");
            }
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            this.teleport = teleport;
            this.travel = travel;
            this.type = type;
            this.whenLogin = whenLogin;
        }
    }
}

