/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.slimjar.downloader.strategy;

import java.io.File;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import tr.com.infumia.infumialib.slimjar.downloader.strategy.FilePathStrategy;
import tr.com.infumia.infumialib.slimjar.resolver.data.Dependency;

public final class FolderedFilePathStrategy
implements FilePathStrategy {
    private static final String DEPENDENCY_FILE_FORMAT = "%s/%s/%s/%s/%3$s-%4$s.jar";
    private static final Logger LOGGER = Logger.getLogger(FolderedFilePathStrategy.class.getName());
    private final File rootDirectory;

    private FolderedFilePathStrategy(File rootDirectory) {
        this.rootDirectory = rootDirectory;
    }

    public static FilePathStrategy createStrategy(File rootDirectory) throws IllegalArgumentException {
        boolean created;
        if (!rootDirectory.exists() && !(created = rootDirectory.mkdirs())) {
            throw new IllegalArgumentException("Could not create specified directory: " + rootDirectory);
        }
        if (!rootDirectory.isDirectory()) {
            throw new IllegalArgumentException("Expecting a directory for download root! " + rootDirectory);
        }
        return new FolderedFilePathStrategy(rootDirectory);
    }

    @Override
    public File selectFileFor(Dependency dependency) {
        String extendedVersion = Optional.ofNullable(dependency.getSnapshotId()).map(s -> "-" + s).orElse("");
        String path = String.format(DEPENDENCY_FILE_FORMAT, this.rootDirectory.getPath(), dependency.getGroupId().replace('.', '/'), dependency.getArtifactId(), dependency.getVersion() + extendedVersion);
        LOGGER.log(Level.FINEST, "Selected jar file for " + dependency.getArtifactId() + " at " + path);
        return new File(path);
    }
}

