/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.slimjar.app.builder;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import tr.com.infumia.infumialib.slimjar.app.module.ModuleExtractor;
import tr.com.infumia.infumialib.slimjar.app.module.TemporaryModuleExtractor;
import tr.com.infumia.infumialib.slimjar.util.Modules;

public final class IsolationConfiguration {
    private final String applicationClass;
    private final ModuleExtractor moduleExtractor;
    private final Collection<String> modules;
    private final ClassLoader parentClassloader;

    public IsolationConfiguration(String applicationClass, Collection<String> modules, ClassLoader parentClassloader, ModuleExtractor moduleExtractor) {
        this.applicationClass = applicationClass;
        this.modules = Collections.unmodifiableCollection(modules);
        this.parentClassloader = parentClassloader;
        this.moduleExtractor = moduleExtractor;
    }

    public static Builder builder(String applicationClass) {
        return new Builder().applicationClass(applicationClass);
    }

    public String getApplicationClass() {
        return this.applicationClass;
    }

    public ModuleExtractor getModuleExtractor() {
        return this.moduleExtractor;
    }

    public Collection<String> getModules() {
        return this.modules;
    }

    public ClassLoader getParentClassloader() {
        return this.parentClassloader;
    }

    public static final class Builder {
        private String applicationClass;
        private ModuleExtractor moduleExtractor;
        private Collection<String> modules = new HashSet<String>();
        private ClassLoader parentClassloader;

        public Builder applicationClass(String applicationClass) {
            this.applicationClass = applicationClass;
            return this;
        }

        public IsolationConfiguration build() throws IOException, URISyntaxException {
            return new IsolationConfiguration(this.getApplicationClass(), this.getModules(), this.getParentClassloader(), this.getModuleExtractor());
        }

        public Builder module(String module) {
            this.modules.add(module);
            return this;
        }

        public Builder moduleExtractor(ModuleExtractor moduleExtractor) {
            this.moduleExtractor = moduleExtractor;
            return this;
        }

        public Builder modules(Collection<String> modules) {
            HashSet<String> mod = new HashSet<String>(modules);
            mod.addAll(modules);
            this.modules = mod;
            return this;
        }

        public Builder parentClassLoader(ClassLoader classLoader) {
            this.parentClassloader = classLoader;
            return this;
        }

        String getApplicationClass() {
            if (this.applicationClass == null) {
                throw new AssertionError((Object)"Application Class not Provided!");
            }
            return this.applicationClass;
        }

        ModuleExtractor getModuleExtractor() {
            if (this.moduleExtractor == null) {
                this.moduleExtractor = new TemporaryModuleExtractor();
            }
            return this.moduleExtractor;
        }

        Collection<String> getModules() throws IOException, URISyntaxException {
            if (this.modules == null || this.modules.isEmpty()) {
                this.modules = Modules.findLocalModules();
            }
            return this.modules;
        }

        ClassLoader getParentClassloader() {
            if (this.parentClassloader == null) {
                this.parentClassloader = ClassLoader.getSystemClassLoader().getParent();
            }
            return this.parentClassloader;
        }
    }
}

