/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.slimjar.downloader.verify;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.util.Objects;
import java.util.Optional;
import tr.com.infumia.infumialib.slimjar.downloader.output.OutputWriter;
import tr.com.infumia.infumialib.slimjar.downloader.output.OutputWriterFactory;
import tr.com.infumia.infumialib.slimjar.downloader.verify.ChecksumCalculator;
import tr.com.infumia.infumialib.slimjar.downloader.verify.DependencyVerifier;
import tr.com.infumia.infumialib.slimjar.logging.LogDispatcher;
import tr.com.infumia.infumialib.slimjar.logging.ProcessLogger;
import tr.com.infumia.infumialib.slimjar.resolver.DependencyResolver;
import tr.com.infumia.infumialib.slimjar.resolver.ResolutionResult;
import tr.com.infumia.infumialib.slimjar.resolver.data.Dependency;
import tr.com.infumia.infumialib.slimjar.util.Connections;

public final class ChecksumDependencyVerifier
implements DependencyVerifier {
    private static final ProcessLogger LOGGER = LogDispatcher.getMediatingLogger();
    private final ChecksumCalculator checksumCalculator;
    private final DependencyVerifier fallbackVerifier;
    private final OutputWriterFactory outputWriterFactory;
    private final DependencyResolver resolver;

    public ChecksumDependencyVerifier(DependencyResolver resolver, OutputWriterFactory outputWriterFactory, DependencyVerifier fallbackVerifier, ChecksumCalculator checksumCalculator) {
        this.resolver = resolver;
        this.outputWriterFactory = outputWriterFactory;
        this.fallbackVerifier = fallbackVerifier;
        this.checksumCalculator = checksumCalculator;
    }

    @Override
    public File getChecksumFile(Dependency dependency) {
        File checksumFile = this.outputWriterFactory.getStrategy().selectFileFor(dependency);
        checksumFile.getParentFile().mkdirs();
        return checksumFile;
    }

    @Override
    public boolean verify(File file, Dependency dependency) throws IOException {
        if (!file.exists()) {
            return false;
        }
        LOGGER.debug("Verifying checksum for {0}", dependency.getArtifactId());
        File checksumFile = this.outputWriterFactory.getStrategy().selectFileFor(dependency);
        checksumFile.getParentFile().mkdirs();
        if (!checksumFile.exists() && !this.prepareChecksumFile(checksumFile, dependency)) {
            LOGGER.log("Unable to resolve checksum for {0}, falling back to fallbackVerifier!", dependency.getArtifactId());
            return this.fallbackVerifier.verify(file, dependency);
        }
        if (checksumFile.length() == 0L) {
            LOGGER.log("Required checksum not found for {0}, using fallbackVerifier!", dependency.getArtifactId());
            return this.fallbackVerifier.verify(file, dependency);
        }
        String actualChecksum = this.checksumCalculator.calculate(file);
        String expectedChecksum = new String(Files.readAllBytes(checksumFile.toPath())).trim();
        LOGGER.debug("{0} -> Actual checksum: {1};", dependency.getArtifactId(), actualChecksum);
        LOGGER.debug("{0} -> Expected checksum: {1};", dependency.getArtifactId(), expectedChecksum);
        boolean match = Objects.equals(actualChecksum, expectedChecksum);
        LOGGER.debug("Checksum {0} for {1}", match ? "matched" : "match failed", dependency.getArtifactId());
        return Objects.equals(actualChecksum, expectedChecksum);
    }

    private boolean prepareChecksumFile(File checksumFile, Dependency dependency) throws IOException {
        Optional<ResolutionResult> result = this.resolver.resolve(dependency);
        if (!result.isPresent()) {
            return false;
        }
        URL checkSumUrl = result.get().getChecksumURL();
        LOGGER.debug("Resolved checksum URL for {0} as {1}", dependency.getArtifactId(), checkSumUrl);
        if (checkSumUrl == null) {
            checksumFile.createNewFile();
            return true;
        }
        URLConnection connection = Connections.createDownloadConnection(checkSumUrl);
        InputStream inputStream = connection.getInputStream();
        OutputWriter outputWriter = this.outputWriterFactory.create(dependency);
        outputWriter.writeFrom(inputStream, connection.getContentLength());
        Connections.tryDisconnect(connection);
        LOGGER.debug("Downloaded checksum for {0}", dependency.getArtifactId());
        return true;
    }
}

