/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.files;

import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.configurate.CommentedConfigurationNode;
import org.spongepowered.configurate.ConfigurateException;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.hocon.HoconConfigurationLoader;
import org.spongepowered.configurate.objectmapping.ConfigSerializable;
import org.spongepowered.configurate.objectmapping.meta.Comment;

@ConfigSerializable
public final class InfumiaConfig {
    @NotNull
    private static InfumiaConfig INSTANCE = new InfumiaConfig();
    @Comment(value="The quarkus http api's endpoint address.")
    private String apiEndpoint = "http://localhost:8080";
    @Comment(value="Checks update for the Infumia library plugin.")
    private boolean checkForUpdate = true;

    public static void init(@NotNull Path directory) throws ConfigurateException {
        HoconConfigurationLoader loader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().path(directory.resolve("config.conf"))).build();
        CommentedConfigurationNode node = (CommentedConfigurationNode)loader.load();
        InfumiaConfig config = (InfumiaConfig)node.get(InfumiaConfig.class, (Object)new InfumiaConfig());
        node.set(InfumiaConfig.class, (Object)config);
        loader.save((ConfigurationNode)node);
        INSTANCE = config;
    }

    @NotNull
    public static InfumiaConfig instance() {
        return INSTANCE;
    }

    public String apiEndpoint() {
        return this.apiEndpoint;
    }

    public boolean checkForUpdate() {
        return this.checkForUpdate;
    }

    public InfumiaConfig apiEndpoint(String apiEndpoint) {
        this.apiEndpoint = apiEndpoint;
        return this;
    }

    public InfumiaConfig checkForUpdate(boolean checkForUpdate) {
        this.checkForUpdate = checkForUpdate;
        return this;
    }
}

