/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.transformer.resolvers;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tr.com.infumia.infumialib.transformer.TransformResolver;
import tr.com.infumia.infumialib.transformer.declarations.FieldDeclaration;
import tr.com.infumia.infumialib.transformer.declarations.GenericDeclaration;
import tr.com.infumia.infumialib.transformer.resolvers.WrappedTransformResolver;

public final class InMemoryWrappedResolver
extends WrappedTransformResolver {
    @NotNull
    private final Map<String, Object> map;

    public InMemoryWrappedResolver(@NotNull TransformResolver resolver, @NotNull Map<String, Object> map) {
        super(resolver);
        this.map = new Object2ObjectOpenHashMap(map);
    }

    @Override
    @NotNull
    public List<String> allKeys() {
        return List.copyOf(this.map.keySet());
    }

    @Override
    @NotNull
    public Optional<Object> getValue(@NotNull String path) {
        return Optional.ofNullable(this.map.get(path));
    }

    @Override
    @NotNull
    public <T> Optional<T> getValue(@NotNull String path, @NotNull Class<T> cls, @Nullable GenericDeclaration genericType, @Nullable Object defaultValue) {
        return this.getValue(path).map(value -> this.deserialize(value, GenericDeclaration.of(value), cls, genericType, defaultValue));
    }

    @Override
    public boolean pathExists(@NotNull String path) {
        return this.map.containsKey(path);
    }

    @Override
    public void removeValue(@NotNull String path, @Nullable GenericDeclaration genericType, @Nullable FieldDeclaration field) {
        this.map.remove(path);
    }

    @Override
    public void setValue(@NotNull String path, @Nullable Object value, @Nullable GenericDeclaration genericType, @Nullable FieldDeclaration field) {
        this.map.put(path, value);
    }
}

