/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.dynamism;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.infumialib.definition.Definition;
import tr.com.infumia.infumialib.dynamism.Dynamic;
import tr.com.infumia.infumialib.dynamism.DynamicRegistry;
import tr.com.infumia.infumialib.misc.Jackson;

public interface DynamicStore
extends Definition.ToJsonText {
    @NotNull
    public static DynamicStore empty(@NotNull DynamicRegistry registry) {
        return new Impl(registry);
    }

    @NotNull
    public <T extends Dynamic> T dynamic(@NotNull Class<T> var1);

    @NotNull
    public Dynamic dynamic(@NotNull String var1);

    public void dynamic(@NotNull Dynamic var1);

    public static final class Impl
    implements DynamicStore {
        @NotNull
        private final Map<Class<? extends Dynamic>, Dynamic> dynamicsByClass = new ConcurrentHashMap<Class<? extends Dynamic>, Dynamic>();
        @NotNull
        private final Map<String, Dynamic> dynamicsByKey = new ConcurrentHashMap<String, Dynamic>();
        @NotNull
        private final DynamicRegistry registry;

        @Override
        @NotNull
        public <T extends Dynamic> T dynamic(@NotNull Class<T> cls) {
            Dynamic dynamic = this.dynamicsByClass.get(cls);
            if (dynamic == null) {
                dynamic = this.registry.create(cls);
            }
            return (T)dynamic;
        }

        @Override
        @NotNull
        public Dynamic dynamic(@NotNull String key) {
            Dynamic dynamic = this.dynamicsByKey.get(key);
            if (dynamic == null) {
                dynamic = this.registry.create(key);
            }
            return dynamic;
        }

        @Override
        public void dynamic(@NotNull Dynamic dynamic) {
            this.dynamicsByKey.put((String)dynamic.key(), dynamic);
            this.dynamicsByClass.put(dynamic.getClass(), dynamic);
        }

        @Override
        @NotNull
        public String toJsonAsText() {
            return Jackson.JSON_MAPPER.writeValueAsString(this.dynamicsByKey);
        }

        private Impl(@NotNull DynamicRegistry registry) {
            if (registry == null) {
                throw new NullPointerException("registry is marked non-null but is null");
            }
            this.registry = registry;
        }
    }
}

