/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.slimjar.app.module;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import tr.com.infumia.infumialib.slimjar.app.module.ModuleExtractor;
import tr.com.infumia.infumialib.slimjar.app.module.ModuleNotFoundException;

public final class TemporaryModuleExtractor
implements ModuleExtractor {
    @Override
    public URL extractModule(URL url, String name) throws IOException {
        File tempFile = File.createTempFile(name, ".jar");
        tempFile.deleteOnExit();
        URLConnection connection = url.openConnection();
        if (!(connection instanceof JarURLConnection)) {
            throw new AssertionError((Object)"Invalid Module URL provided(Non-Jar File)");
        }
        JarURLConnection jarURLConnection = (JarURLConnection)connection;
        JarFile jarFile = jarURLConnection.getJarFile();
        JarEntry module = jarFile.getJarEntry(name + ".isolated-jar");
        if (module == null) {
            throw new ModuleNotFoundException(name);
        }
        try (InputStream inputStream = jarFile.getInputStream(module);){
            Files.copy(inputStream, tempFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        return tempFile.toURI().toURL();
    }
}

