/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.slimjar.app.builder;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.Map;
import tr.com.infumia.infumialib.slimjar.app.Application;
import tr.com.infumia.infumialib.slimjar.app.builder.ApplicationBuilder;
import tr.com.infumia.infumialib.slimjar.app.builder.IsolationConfiguration;
import tr.com.infumia.infumialib.slimjar.injector.DependencyInjector;
import tr.com.infumia.infumialib.slimjar.injector.loader.IsolatedInjectableClassLoader;
import tr.com.infumia.infumialib.slimjar.resolver.ResolutionResult;
import tr.com.infumia.infumialib.slimjar.resolver.data.DependencyData;
import tr.com.infumia.infumialib.slimjar.resolver.reader.dependency.DependencyDataProvider;
import tr.com.infumia.infumialib.slimjar.resolver.reader.resolution.PreResolutionDataProvider;
import tr.com.infumia.infumialib.slimjar.util.Modules;
import tr.com.infumia.infumialib.slimjar.util.Parameters;

public final class IsolatedApplicationBuilder
extends ApplicationBuilder {
    private final Object[] arguments;
    private final IsolationConfiguration isolationConfiguration;

    public IsolatedApplicationBuilder(String applicationName, IsolationConfiguration isolationConfiguration, Object[] arguments) {
        super(applicationName);
        this.isolationConfiguration = isolationConfiguration;
        this.arguments = (Object[])arguments.clone();
    }

    @Override
    public Application buildApplication() throws IOException, ReflectiveOperationException, URISyntaxException, NoSuchAlgorithmException {
        DependencyInjector injector = this.createInjector();
        URL[] moduleUrls = Modules.extract(this.isolationConfiguration.getModuleExtractor(), this.isolationConfiguration.getModules());
        IsolatedInjectableClassLoader classLoader = new IsolatedInjectableClassLoader(moduleUrls, this.isolationConfiguration.getParentClassloader(), Collections.singleton(Application.class));
        DependencyDataProvider dataProvider = this.getDataProviderFactory().create(this.getDependencyFileUrl());
        DependencyData selfDependencyData = dataProvider.get();
        PreResolutionDataProvider preResolutionDataProvider = this.getPreResolutionDataProviderFactory().create(this.getPreResolutionFileUrl());
        Map<String, ResolutionResult> preResolutionResultMap = preResolutionDataProvider.get();
        injector.inject(classLoader, selfDependencyData, preResolutionResultMap);
        for (URL module : moduleUrls) {
            DependencyDataProvider moduleDataProvider = this.getModuleDataProviderFactory().create(module);
            DependencyData dependencyData = moduleDataProvider.get();
            injector.inject(classLoader, dependencyData, preResolutionResultMap);
        }
        Class<?> applicationClass = Class.forName(this.isolationConfiguration.getApplicationClass(), true, classLoader);
        return (Application)applicationClass.getConstructor(Parameters.typesFrom(this.arguments)).newInstance(this.arguments);
    }
}

