/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.messaging;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.base.Preconditions;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tr.com.infumia.infumialib.messaging.ErrorHandler;
import tr.com.infumia.infumialib.messaging.Portal;
import tr.com.infumia.infumialib.messaging.ServerSender;
import tr.com.infumia.infumialib.messaging.errors.BooleanResult;
import tr.com.infumia.infumialib.messaging.errors.PositionResult;
import tr.com.infumia.infumialib.messengers.GameplayMessenger;
import tr.com.infumia.infumialib.proto.Definitions;
import tr.com.infumia.infumialib.proto.Messaging;

public interface Travel {
    @NotNull
    public ErrorHandler errorHandler();

    @NotNull
    public GameplayMessenger gameplayMessenger();

    public boolean isTravelling(@NotNull String var1);

    @NotNull
    default public BooleanResult sendRequest(@NotNull String type, @NotNull Definitions.OfflineUser source, @NotNull String data, @NotNull Supplier<@Nullable Definitions.Error> errorCatcher) {
        return Portal.get(type).map(portal -> portal.sendRequest(source, data, errorCatcher)).orElse(new BooleanResult(Definitions.Error.newBuilder().setError("portal-not-found").addArgs(type).build(), null));
    }

    public void sendRequest(@NotNull Messaging.Travel.Request var1, @NotNull String var2, @NotNull Supplier<@Nullable Definitions.Error> var3);

    @NotNull
    public ServerSender serverSender();

    public static final class Result {
        @Nullable
        private final Definitions.Error error;
        @Nullable
        private final @Nullable Supplier< @NotNull Map.Entry<@Nullable Definitions.Position, @Nullable Definitions.Error>> supplier;

        @Contract(value="null, null -> fail")
        public Result(@Nullable Definitions.Error error, @Nullable @Nullable Supplier< @NotNull Map.Entry<@Nullable Definitions.Position, @Nullable Definitions.Error>> supplier) {
            Preconditions.checkState((error != null || supplier != null ? 1 : 0) != 0, (Object)"Both error and supplier are null!");
            this.error = error;
            this.supplier = supplier;
        }

        @Nullable
        public Definitions.Error error() {
            return this.error;
        }

        @Nullable
        public @Nullable Supplier< @NotNull Map.Entry<@Nullable Definitions.Position, @Nullable Definitions.Error>> supplier() {
            return this.supplier;
        }
    }

    public record Response(@NotNull Supplier<@Nullable Definitions.Error> errorCatcher, long time, @NotNull String type) {
        public Response(@NotNull Supplier<@Nullable Definitions.Error> errorCatcher, @NotNull String type) {
            this(errorCatcher, System.currentTimeMillis(), type);
        }
    }

    public record Request(@NotNull Supplier<Pair<@Nullable Definitions.Position, @Nullable Definitions.Error>> supplier, long time, @NotNull String type) {
        public Request(@NotNull Supplier<Pair<@Nullable Definitions.Position, @Nullable Definitions.Error>> supplier, @NotNull String type) {
            this(supplier, System.currentTimeMillis(), type);
        }
    }

    public static abstract class Base
    implements Travel {
        @NotNull
        protected final @NotNull Cache<@NotNull String, @NotNull String> transfer = Caffeine.newBuilder().expireAfterWrite(10L, TimeUnit.SECONDS).build();
        @NotNull
        private final ErrorHandler errorHandler;
        @NotNull
        private final GameplayMessenger gameplayMessenger;
        @NotNull
        private final @NotNull Cache<@NotNull String, @NotNull Request> requests = Caffeine.newBuilder().expireAfterWrite(30L, TimeUnit.SECONDS).build();
        @NotNull
        private final @NotNull Cache<@NotNull String, @NotNull Response> responses = Caffeine.newBuilder().expireAfterWrite(30L, TimeUnit.SECONDS).build();
        @NotNull
        private final ServerSender serverSender;

        protected Base(@NotNull GameplayMessenger gameplayMessenger, @NotNull ErrorHandler errorHandler, @NotNull ServerSender serverSender) {
            this.gameplayMessenger = gameplayMessenger;
            this.errorHandler = errorHandler;
            this.serverSender = serverSender;
            this.gameplayMessenger.subscribe(Messaging.Travel.Request.getDefaultInstance(), this::onRequest);
            this.gameplayMessenger.subscribe(Messaging.Travel.Response.getDefaultInstance(), this::onResponse);
        }

        @Override
        public final boolean isTravelling(@NotNull String uniqueId) {
            return this.transfer.asMap().containsKey(uniqueId);
        }

        @Override
        public final void sendRequest(@NotNull Messaging.Travel.Request request, @NotNull String targetServer, @NotNull Supplier<@Nullable Definitions.Error> errorCatcher) {
            this.responses.put((Object)request.getSource().getId(), (Object)new Response(errorCatcher, request.getType()));
            this.gameplayMessenger.publish(targetServer, request);
        }

        private void onRequest(@NotNull Messaging.ServerMessage serverMessage, @NotNull Messaging.Travel.Request request) {
            String type = request.getType();
            Portal.get(type).ifPresentOrElse(portal -> portal.deserialize(request.getValue().toByteArray()).ifPresentOrElse(s -> {
                Definitions.OfflineUser source = request.getSource();
                PositionResult result = portal.onRequest(source, (String)s);
                Definitions.Error error = result.error();
                Supplier<Pair<Definitions.Position, Definitions.Error>> supplier = result.supplier();
                if (supplier == null || error != null) {
                    this.sendResponse(serverMessage, request, error);
                    return;
                }
                this.requests.put((Object)source.getId(), (Object)new Request(supplier, portal.type()));
                this.sendResponse(serverMessage, request, null);
            }, () -> this.sendResponse(serverMessage, request, Definitions.Error.newBuilder().setError("unexpected-1").build())), () -> this.sendResponse(serverMessage, request, Definitions.Error.newBuilder().setError("portal-not-found").addArgs(type).build()));
        }

        private void onResponse(@NotNull Messaging.ServerMessage serverMessage, @NotNull Messaging.Travel.Response travelResponse) {
            String uniqueId = travelResponse.getSource().getId();
            Response response = (Response)this.responses.getIfPresent((Object)uniqueId);
            if (response == null) {
                this.errorHandler.onError(uniqueId, Definitions.Error.newBuilder().setError("response-not-found").build());
                return;
            }
            this.responses.invalidate((Object)uniqueId);
            boolean done = travelResponse.getDone();
            if (!done) {
                this.errorHandler.onError(uniqueId, travelResponse.getReason());
                return;
            }
            Definitions.Error caughtError = response.errorCatcher().get();
            if (caughtError != null) {
                this.errorHandler.onError(uniqueId, caughtError);
                return;
            }
            String server = serverMessage.getSource();
            this.transfer.invalidate((Object)uniqueId);
            this.transfer.put((Object)uniqueId, (Object)server);
            this.serverSender.send(uniqueId, server);
        }

        private void sendResponse(@NotNull Messaging.ServerMessage message, @NotNull Messaging.Travel.Request request, @Nullable Definitions.Error error) {
            Messaging.Travel.Response.Builder response = Messaging.Travel.Response.newBuilder().setSource(request.getSource()).setType(request.getType()).setDone(error == null);
            if (error != null) {
                response.setReason(error);
            }
            this.gameplayMessenger.publish(message.getSource(), response.build());
        }

        @Override
        @NotNull
        public ErrorHandler errorHandler() {
            return this.errorHandler;
        }

        @Override
        @NotNull
        public GameplayMessenger gameplayMessenger() {
            return this.gameplayMessenger;
        }

        @Override
        @NotNull
        public ServerSender serverSender() {
            return this.serverSender;
        }
    }
}

