/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.platform.paper.transformer.serializers;

import com.cryptomorin.xseries.messages.Titles;
import java.util.Map;
import java.util.Optional;
import java.util.function.UnaryOperator;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tr.com.infumia.infumialib.replaceable.RpString;
import tr.com.infumia.infumialib.transformer.ObjectSerializer;
import tr.com.infumia.infumialib.transformer.TransformedData;
import tr.com.infumia.infumialib.transformer.declarations.GenericDeclaration;

public final class SentTitle {
    private transient int $hashCodeCache;
    private final int fadeIn;
    private final int fadeOut;
    private final int stay;
    @Nullable
    private final RpString subTitle;
    @Nullable
    private final RpString title;

    public SentTitle(@Nullable String title, @Nullable String subTitle, int fadeIn, int stay, int fadeOut) {
        this(title == null ? null : RpString.from(title), subTitle == null ? null : RpString.from(subTitle), fadeIn, stay, fadeOut);
    }

    public SentTitle(@Nullable RpString title, @Nullable RpString subTitle, int fadeIn, int stay, int fadeOut) {
        this.title = title;
        this.subTitle = subTitle;
        this.fadeIn = fadeIn;
        this.stay = stay;
        this.fadeOut = fadeOut;
    }

    @SafeVarargs
    public final void send(@NotNull Player player, Map.Entry<String, Object> ... entries) {
        Titles.sendTitle((Player)player, (int)this.fadeIn, (int)this.stay, (int)this.fadeOut, (String)(this.title == null ? null : (String)this.title.build(entries)), this.subTitle == null ? null : (String)this.subTitle.build(entries));
    }

    @SafeVarargs
    public final void send(@NotNull Player player, @NotNull UnaryOperator<String> title, @NotNull UnaryOperator<String> subTitle, Map.Entry<String, Object> ... entries) {
        Titles.sendTitle((Player)player, (int)this.fadeIn, (int)this.stay, (int)this.fadeOut, this.title == null ? null : (String)title.apply((String)this.title.build(entries)), this.subTitle == null ? null : (String)subTitle.apply((String)this.subTitle.build(entries)));
    }

    @NotNull
    public String getSubTitleAsValue() {
        return this.subTitle == null ? "" : (String)this.subTitle.getValue();
    }

    @NotNull
    public String getTitleAsValue() {
        return this.title == null ? "" : (String)this.title.getValue();
    }

    @NotNull
    public SentTitle valueOfSubTitle(@Nullable String newSubTitle) {
        RpString finalNewSubTitle = newSubTitle == null ? null : (this.subTitle == null ? RpString.from(newSubTitle) : (RpString)this.subTitle.value(newSubTitle));
        return new SentTitle(this.title, finalNewSubTitle, this.fadeIn, this.stay, this.fadeOut);
    }

    @NotNull
    public SentTitle valueOfTitle(@Nullable String newTitle) {
        RpString finalNewTitle = newTitle == null ? null : (this.title == null ? RpString.from(newTitle) : (RpString)this.title.value(newTitle));
        return new SentTitle(finalNewTitle, this.subTitle, this.fadeIn, this.stay, this.fadeOut);
    }

    public int getFadeIn() {
        return this.fadeIn;
    }

    public int getFadeOut() {
        return this.fadeOut;
    }

    public int getStay() {
        return this.stay;
    }

    @Nullable
    public RpString getSubTitle() {
        return this.subTitle;
    }

    @Nullable
    public RpString getTitle() {
        return this.title;
    }

    public String toString() {
        return "SentTitle(fadeIn=" + this.getFadeIn() + ", fadeOut=" + this.getFadeOut() + ", stay=" + this.getStay() + ", subTitle=" + this.getSubTitle() + ", title=" + this.getTitle() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SentTitle)) {
            return false;
        }
        SentTitle other = (SentTitle)o;
        if (this.fadeIn != other.fadeIn) {
            return false;
        }
        if (this.fadeOut != other.fadeOut) {
            return false;
        }
        if (this.stay != other.stay) {
            return false;
        }
        RpString this$subTitle = this.subTitle;
        RpString other$subTitle = other.subTitle;
        if (this$subTitle == null ? other$subTitle != null : !((Object)this$subTitle).equals(other$subTitle)) {
            return false;
        }
        RpString this$title = this.title;
        RpString other$title = other.title;
        return !(this$title == null ? other$title != null : !((Object)this$title).equals(other$title));
    }

    public int hashCode() {
        if (this.$hashCodeCache != 0) {
            return this.$hashCodeCache;
        }
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.fadeIn;
        result = result * 59 + this.fadeOut;
        result = result * 59 + this.stay;
        RpString $subTitle = this.subTitle;
        result = result * 59 + ($subTitle == null ? 43 : ((Object)$subTitle).hashCode());
        RpString $title = this.title;
        if ((result = result * 59 + ($title == null ? 43 : ((Object)$title).hashCode())) == 0) {
            result = Integer.MIN_VALUE;
        }
        this.$hashCodeCache = result;
        return result;
    }

    public static final class Serializer
    implements ObjectSerializer<SentTitle> {
        @Override
        @NotNull
        public Optional<SentTitle> deserialize(@NotNull TransformedData transformedData, @Nullable GenericDeclaration declaration) {
            return Optional.empty();
        }

        @Override
        @NotNull
        public Optional<SentTitle> deserialize(@NotNull SentTitle field, @NotNull TransformedData transformedData, @Nullable GenericDeclaration declaration) {
            Optional<RpString> title = transformedData.get("title", RpString.class, field.getTitle());
            Optional<RpString> subTitle = transformedData.get("sub-title", RpString.class, field.getSubTitle());
            if (title.isEmpty() && subTitle.isEmpty()) {
                return Optional.empty();
            }
            Integer fadeIn = transformedData.get("fade-in", Integer.TYPE).orElse(20);
            Integer stay = transformedData.get("stay", Integer.TYPE).orElse(20);
            Integer fadeOut = transformedData.get("fade-out", Integer.TYPE).orElse(20);
            return Optional.of(new SentTitle(title.orElse(null), subTitle.orElse(null), (int)fadeIn, (int)stay, (int)fadeOut));
        }

        @Override
        public void serialize(@NotNull SentTitle sentTitle, @NotNull TransformedData transformedData) {
            if (sentTitle.getTitle() != null) {
                transformedData.add("title", sentTitle.getTitle(), RpString.class);
            }
            if (sentTitle.getSubTitle() != null) {
                transformedData.add("sub-title", sentTitle.getSubTitle(), RpString.class);
            }
            transformedData.add("fade-in", sentTitle.fadeIn);
            transformedData.add("stay", sentTitle.stay);
            transformedData.add("fade-out", sentTitle.fadeOut);
        }

        @Override
        public boolean supports(@NotNull Class<?> cls) {
            return cls == SentTitle.class;
        }
    }
}

