/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.platform.paper.smartinventory.content;

import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.infumialib.platform.paper.smartinventory.Icon;
import tr.com.infumia.infumialib.platform.paper.smartinventory.Pagination;

public final class BasicPagination
implements Pagination {
    private int currentPage;
    @NotNull
    private Icon[] icons = new Icon[0];
    private int iconsPerPage = 5;

    @Override
    @NotNull
    public Pagination first() {
        this.currentPage = 0;
        return this;
    }

    @Override
    public int getPage() {
        return this.currentPage;
    }

    @Override
    @NotNull
    public Icon[] getPageIcons() {
        return Arrays.copyOfRange(this.icons, this.currentPage * this.iconsPerPage, (this.currentPage + 1) * this.iconsPerPage);
    }

    @Override
    public boolean isFirst() {
        return this.currentPage == 0;
    }

    @Override
    public boolean isLast() {
        return this.currentPage >= (int)Math.ceil((double)this.icons.length / (double)this.iconsPerPage) - 1;
    }

    @Override
    @NotNull
    public Pagination last() {
        return this.page(this.getPageIcons().length / this.iconsPerPage);
    }

    @Override
    @NotNull
    public Pagination next() {
        if (!this.isLast()) {
            ++this.currentPage;
        }
        return this;
    }

    @Override
    @NotNull
    public Pagination page(int page) {
        this.currentPage = page;
        return this;
    }

    @Override
    @NotNull
    public Pagination previous() {
        if (!this.isFirst()) {
            --this.currentPage;
        }
        return this;
    }

    @Override
    @NotNull
    public Pagination setIcons(Icon ... icons) {
        this.icons = (Icon[])icons.clone();
        return this;
    }

    @Override
    @NotNull
    public Pagination setIconsPerPage(int iconsPerPage) {
        this.iconsPerPage = iconsPerPage;
        return this;
    }
}

