/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.platform.paper.files;

import java.nio.file.Path;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.infumialib.platform.paper.color.XColor;
import tr.com.infumia.infumialib.platform.paper.transformer.resolvers.BukkitSnakeyaml;
import tr.com.infumia.infumialib.replaceable.RpString;
import tr.com.infumia.infumialib.transformer.TransformedObject;
import tr.com.infumia.infumialib.transformer.TransformerPool;
import tr.com.infumia.infumialib.transformer.annotations.Comment;
import tr.com.infumia.infumialib.transformer.annotations.Names;
import tr.com.infumia.infumialib.transformer.annotations.Version;

@Version
@Names(modifier=Names.Modifier.TO_LOWER_CASE, strategy=Names.Strategy.HYPHEN_CASE)
public final class PaperConfig
extends TransformedObject {
    @Comment(value={"Hooking message for each plugin/library."})
    public static RpString hookMessage = (RpString)((RpString)RpString.from("{#F0E68C}%hook% {#AFEEEE}is hooking.").regex("%hook%")).map(XColor::colorize);
    @Comment(value={"Whether enable multiple server support or not."})
    public static boolean multiServer = false;
    @Comment(value={"Redis sentinel password."})
    public static String redisPassword = "password";
    @Comment(value={"Server's group."})
    public static String serverGroup = "lobby";
    @Comment(value={"Server's name."})
    public static String serverName = UUID.randomUUID().toString();

    public static void loadConfig(@NotNull Path file) {
        TransformerPool.create(new PaperConfig()).withFile(file).withResolver(new BukkitSnakeyaml()).initiate();
    }

    private PaperConfig() {
    }
}

