/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.slimjar.resolver.reader.facade;

import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import tr.com.infumia.infumialib.slimjar.resolver.reader.facade.GsonFacade;

public final class ReflectiveGsonFacade
implements GsonFacade {
    private final Method canonicalizeMethod;
    private final Object gson;
    private final Method gsonFromJsonMethod;
    private final Method gsonFromJsonTypeMethod;

    ReflectiveGsonFacade(Object gson, Method gsonFromJsonMethod, Method gsonFromJsonTypeMethod, Method canonicalizeMethod) {
        this.gson = gson;
        this.gsonFromJsonMethod = gsonFromJsonMethod;
        this.gsonFromJsonTypeMethod = gsonFromJsonTypeMethod;
        this.canonicalizeMethod = canonicalizeMethod;
    }

    @Override
    public <T> T fromJson(InputStreamReader reader, Class<T> clazz) throws ReflectiveOperationException {
        Object result = this.gsonFromJsonMethod.invoke(this.gson, reader, clazz);
        if (clazz.isAssignableFrom(result.getClass())) {
            return (T)result;
        }
        throw new AssertionError((Object)"Gson returned wrong type!");
    }

    @Override
    public <T> T fromJson(InputStreamReader reader, Type rawType) throws ReflectiveOperationException {
        Object canonicalizedType = this.canonicalizeMethod.invoke(null, rawType);
        Object result = this.gsonFromJsonTypeMethod.invoke(this.gson, reader, canonicalizedType);
        return (T)result;
    }
}

