/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.slimjar.resolver.enquirer;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Optional;
import tr.com.infumia.infumialib.slimjar.logging.LogDispatcher;
import tr.com.infumia.infumialib.slimjar.logging.ProcessLogger;
import tr.com.infumia.infumialib.slimjar.resolver.ResolutionResult;
import tr.com.infumia.infumialib.slimjar.resolver.data.Dependency;
import tr.com.infumia.infumialib.slimjar.resolver.data.Repository;
import tr.com.infumia.infumialib.slimjar.resolver.enquirer.RepositoryEnquirer;
import tr.com.infumia.infumialib.slimjar.resolver.pinger.URLPinger;
import tr.com.infumia.infumialib.slimjar.resolver.strategy.PathResolutionStrategy;

public final class PingingRepositoryEnquirer
implements RepositoryEnquirer {
    private static final ProcessLogger LOGGER = LogDispatcher.getMediatingLogger();
    private final PathResolutionStrategy checksumURLCreationStrategy;
    private final PathResolutionStrategy dependencyURLCreationStrategy;
    private final PathResolutionStrategy pomURLCreationStrategy;
    private final Repository repository;
    private final URLPinger urlPinger;

    public PingingRepositoryEnquirer(Repository repository, PathResolutionStrategy urlCreationStrategy, PathResolutionStrategy checksumURLCreationStrategy, PathResolutionStrategy pomURLCreationStrategy, URLPinger urlPinger) {
        this.repository = repository;
        this.dependencyURLCreationStrategy = urlCreationStrategy;
        this.checksumURLCreationStrategy = checksumURLCreationStrategy;
        this.pomURLCreationStrategy = pomURLCreationStrategy;
        this.urlPinger = urlPinger;
    }

    @Override
    public ResolutionResult enquire(Dependency dependency) {
        LOGGER.debug("Enquiring repositories to find {0}", dependency.getArtifactId());
        Optional<URL> resolvedDependency = this.dependencyURLCreationStrategy.pathTo(this.repository, dependency).stream().map(path -> {
            try {
                return new URL((String)path);
            }
            catch (MalformedURLException e) {
                return null;
            }
        }).filter(this.urlPinger::ping).findFirst();
        if (!resolvedDependency.isPresent()) {
            return this.pomURLCreationStrategy.pathTo(this.repository, dependency).stream().map(path -> {
                try {
                    return new URL((String)path);
                }
                catch (MalformedURLException e) {
                    return null;
                }
            }).filter(this.urlPinger::ping).findFirst().map(url -> new ResolutionResult(this.repository, null, null, true)).orElse(null);
        }
        Optional<URL> resolvedChecksum = this.checksumURLCreationStrategy.pathTo(this.repository, dependency).stream().map(path -> {
            try {
                return new URL((String)path);
            }
            catch (MalformedURLException e) {
                return null;
            }
        }).filter(this.urlPinger::ping).findFirst();
        return new ResolutionResult(this.repository, resolvedDependency.get(), resolvedChecksum.orElse(null), false);
    }
}

