/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.slimjar.resolver;

import java.net.URL;
import java.util.Objects;
import tr.com.infumia.infumialib.slimjar.resolver.data.Repository;

public final class ResolutionResult {
    private final URL checksumURL;
    private final URL dependencyURL;
    private final boolean isAggregator;
    private final Repository repository;

    public ResolutionResult(Repository repository, URL dependencyURL, URL checksumURL, boolean isAggregator) {
        this.repository = repository;
        this.dependencyURL = dependencyURL;
        this.checksumURL = checksumURL;
        this.isAggregator = isAggregator;
        if (!isAggregator) {
            Objects.requireNonNull(dependencyURL, "Resolved URL must not be null for non-aggregator dependencies");
        }
    }

    public URL getChecksumURL() {
        return this.checksumURL;
    }

    public URL getDependencyURL() {
        return this.dependencyURL;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public int hashCode() {
        return Objects.hash(this.dependencyURL.toString(), this.checksumURL.toString(), this.isAggregator);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResolutionResult that = (ResolutionResult)o;
        return this.dependencyURL.toString().equals(that.toString()) && Objects.equals(this.checksumURL.toString(), that.getChecksumURL().toString()) && this.isAggregator == that.isAggregator;
    }

    public boolean isAggregator() {
        return this.isAggregator;
    }
}

