/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.platform.paper.mongodb;

import dev.morphia.annotations.Entity;
import dev.morphia.annotations.Id;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.jetbrains.annotations.NotNull;

@Entity(value="BlockLocation")
public final class BlockLocationObject {
    @Id
    private int id;
    private String world;
    private double x;
    private double y;
    private double z;

    @NotNull
    public static BlockLocationObject fromLocation(@NotNull Location location) {
        return new BlockLocationObject(0, location.getWorld().getName(), location.getX(), location.getY(), location.getZ());
    }

    @NotNull
    public Location toLocation() {
        return new Location(Objects.requireNonNull(Bukkit.getWorld((String)this.world), "World not found!"), this.x, this.y, this.z);
    }

    public String toString() {
        return "BlockLocationObject(id=" + this.id + ", world=" + this.world + ", x=" + this.x + ", y=" + this.y + ", z=" + this.z + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BlockLocationObject)) {
            return false;
        }
        BlockLocationObject other = (BlockLocationObject)o;
        if (this.id != other.id) {
            return false;
        }
        if (Double.compare(this.x, other.x) != 0) {
            return false;
        }
        if (Double.compare(this.y, other.y) != 0) {
            return false;
        }
        if (Double.compare(this.z, other.z) != 0) {
            return false;
        }
        String this$world = this.world;
        String other$world = other.world;
        return !(this$world == null ? other$world != null : !this$world.equals(other$world));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.id;
        long $x = Double.doubleToLongBits(this.x);
        result = result * 59 + (int)($x >>> 32 ^ $x);
        long $y = Double.doubleToLongBits(this.y);
        result = result * 59 + (int)($y >>> 32 ^ $y);
        long $z = Double.doubleToLongBits(this.z);
        result = result * 59 + (int)($z >>> 32 ^ $z);
        String $world = this.world;
        result = result * 59 + ($world == null ? 43 : $world.hashCode());
        return result;
    }

    public BlockLocationObject() {
    }

    public BlockLocationObject(int id, String world, double x, double y, double z) {
        this.id = id;
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
    }
}

