/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.platform.paper.location;

import java.util.List;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.infumialib.platform.paper.location.Directions;

public final class DirectionUtil {
    private DirectionUtil() {
    }

    @NotNull
    public static Directions directionOf(@NotNull Player player) {
        return DirectionUtil.directionOf(player.getLocation());
    }

    @NotNull
    public static Directions directionOf(@NotNull Location location) {
        return DirectionUtil.directionOf(location.getYaw());
    }

    @NotNull
    public static Directions directionOf(float yaw) {
        List<Directions> directions = List.of(Directions.SOUTH, Directions.WEST, Directions.NORTH, Directions.EAST);
        return DirectionUtil.directionOf(directions, yaw);
    }

    @NotNull
    public static Directions doubleDirectionOf(@NotNull Player player) {
        return DirectionUtil.doubleDirectionOf(player.getLocation());
    }

    @NotNull
    public static Directions doubleDirectionOf(@NotNull Location location) {
        return DirectionUtil.doubleDirectionOf(location.getYaw());
    }

    @NotNull
    public static Directions doubleDirectionOf(float yaw) {
        List<Directions> directions = List.of(Directions.SOUTH, Directions.SOUTHWEST, Directions.WEST, Directions.NORTHWEST, Directions.NORTH, Directions.NORTHEAST, Directions.EAST, Directions.SOUTHEAST);
        return DirectionUtil.doubleDirectionOf(directions, yaw);
    }

    @NotNull
    private static Directions directionOf(@NotNull List<Directions> directions, float yaw) {
        return directions.get((int)(Math.abs(yaw) + 45.0f) % 360 / 90);
    }

    @NotNull
    private static Directions doubleDirectionOf(@NotNull List<Directions> directions, float yaw) {
        return directions.get((int)(Math.abs(yaw) + 22.5f) % 360 / 45);
    }
}

