/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.platform.paper.hooks.hooks;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tr.com.infumia.infumialib.hooks.Hook;
import tr.com.infumia.infumialib.platform.paper.hooks.hooks.BentoBoxWrapper;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.addons.Addon;
import world.bentobox.bentobox.api.addons.AddonClassLoader;
import world.bentobox.bentobox.managers.AddonsManager;

public final class BentoBoxHook
implements Hook<BentoBoxWrapper> {
    public static final String ID = "BentoBox";
    @Nullable
    private BentoBox bentoBox;

    @Override
    @NotNull
    public BentoBoxWrapper get() {
        Objects.requireNonNull(this.bentoBox, "BentoBox not initiated! Use BentoBoxHook#initiate() method.");
        AddonsManager addonsManager = this.bentoBox.getAddonsManager();
        Optional addon = addonsManager.getAddonByName("Level");
        Preconditions.checkState((boolean)addon.isPresent(), (Object)"BentoBox not initiated! Use BentoBoxHook#initiate() method.");
        AddonClassLoader loader = addonsManager.getLoader((Addon)addon.get());
        Objects.requireNonNull(loader, "Couldn't find any AddonClassLoader instance.");
        return new BentoBoxWrapper(this.bentoBox, loader);
    }

    @Override
    @NotNull
    public String id() {
        return ID;
    }

    @Override
    public boolean initiate() {
        if (Bukkit.getPluginManager().getPlugin(ID) != null) {
            this.bentoBox = BentoBox.getInstance();
        }
        return this.bentoBox != null && this.bentoBox.getAddonsManager().getAddonByName("Level").isPresent();
    }
}

