/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.kubernetes;

import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.ServiceSpec;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisURI;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Kubernetes {
    @Nullable
    private static KubernetesClient kubernetesClient;
    @Nullable
    private static RedisClient redisClient;

    private Kubernetes() {
    }

    public static void initKubernetesClient() {
        Kubernetes.kubernetesClient((KubernetesClient)new DefaultKubernetesClient());
    }

    public static void initRedis(@NotNull String masterName, @NotNull String password) {
        ServiceSpec sentinel = ((Service)((ServiceResource)((NonNamespaceOperation)Kubernetes.kubernetesClient().services().inNamespace("redis")).withName("sentinel")).get()).getSpec();
        Integer port = ((ServicePort)sentinel.getPorts().get(0)).getPort();
        Kubernetes.redisClient(RedisClient.create((RedisURI)RedisURI.Builder.sentinel((String)sentinel.getClusterIP(), (int)port, (String)masterName).withPassword(password.toCharArray()).build()));
    }

    public static void initRedis(@NotNull String password) {
        Kubernetes.initRedis("mymaster", password);
    }

    public static void initRedis() {
        Kubernetes.initRedis("password");
    }

    public static void kubernetesClient(@Nullable KubernetesClient kubernetesClient) {
        Kubernetes.kubernetesClient = kubernetesClient;
    }

    @NotNull
    public static KubernetesClient kubernetesClient() {
        if (kubernetesClient == null) {
            Kubernetes.initKubernetesClient();
        }
        return kubernetesClient;
    }

    public static void redisClient(@Nullable RedisClient redisClient) {
        Kubernetes.redisClient = redisClient;
    }

    @NotNull
    public static RedisClient redisClient() {
        return Objects.requireNonNull(redisClient, "redis client");
    }
}

