/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.slimjar.util;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.stream.Collectors;
import tr.com.infumia.infumialib.slimjar.app.module.ModuleExtractor;

public final class Modules {
    private Modules() {
    }

    public static URL[] extract(ModuleExtractor extractor, Collection<String> modules) throws IOException {
        URL[] urls = new URL[modules.size()];
        int index = 0;
        for (String moduleName : modules) {
            URL modulePath = Modules.findModule(moduleName);
            URL extractedModule = extractor.extractModule(modulePath, moduleName);
            urls[index++] = extractedModule;
        }
        return urls;
    }

    public static Collection<String> findLocalModules() throws URISyntaxException, IOException {
        URL url = Modules.class.getProtectionDomain().getCodeSource().getLocation();
        Path resourcesPath = Paths.get(url.toURI());
        return Files.walk(resourcesPath, 1, new FileVisitOption[0]).filter(path -> path.endsWith(".isolated-jar")).map(Path::getFileName).map(Path::toString).collect(Collectors.toSet());
    }

    public static URL findModule(String moduleName) {
        ClassLoader classLoader = Modules.class.getClassLoader();
        return classLoader.getResource(moduleName + ".isolated-jar");
    }
}

