/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.slimjar.resolver;

import java.net.URL;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import tr.com.infumia.infumialib.slimjar.logging.LogDispatcher;
import tr.com.infumia.infumialib.slimjar.logging.ProcessLogger;
import tr.com.infumia.infumialib.slimjar.resolver.DependencyResolver;
import tr.com.infumia.infumialib.slimjar.resolver.ResolutionResult;
import tr.com.infumia.infumialib.slimjar.resolver.data.Dependency;
import tr.com.infumia.infumialib.slimjar.resolver.data.Repository;
import tr.com.infumia.infumialib.slimjar.resolver.enquirer.RepositoryEnquirer;
import tr.com.infumia.infumialib.slimjar.resolver.enquirer.RepositoryEnquirerFactory;
import tr.com.infumia.infumialib.slimjar.resolver.pinger.URLPinger;

public final class CachingDependencyResolver
implements DependencyResolver {
    private static final String FAILED_RESOLUTION_MESSAGE = "[FAILED TO RESOLVE]";
    private static final ProcessLogger LOGGER = LogDispatcher.getMediatingLogger();
    private final Map<Dependency, ResolutionResult> cachedResults = new ConcurrentHashMap<Dependency, ResolutionResult>();
    private final Map<String, ResolutionResult> preResolvedResults;
    private final Collection<RepositoryEnquirer> repositories;
    private final URLPinger urlPinger;

    public CachingDependencyResolver(URLPinger urlPinger, Collection<Repository> repositories, RepositoryEnquirerFactory enquirerFactory, Map<String, ResolutionResult> preResolvedResults) {
        this.urlPinger = urlPinger;
        this.preResolvedResults = new ConcurrentHashMap<String, ResolutionResult>(preResolvedResults);
        this.repositories = repositories.stream().map(enquirerFactory::create).collect(Collectors.toSet());
    }

    @Override
    public Optional<ResolutionResult> resolve(Dependency dependency) {
        return Optional.ofNullable(this.cachedResults.computeIfAbsent(dependency, this::attemptResolve));
    }

    private ResolutionResult attemptResolve(Dependency dependency) {
        ResolutionResult preResolvedResult = this.preResolvedResults.get(dependency.toString());
        if (preResolvedResult != null) {
            boolean isChecksumURLValid;
            if (preResolvedResult.isAggregator()) {
                return preResolvedResult;
            }
            boolean isDependencyURLValid = this.urlPinger.ping(preResolvedResult.getDependencyURL());
            URL checksumURL = preResolvedResult.getChecksumURL();
            boolean bl = isChecksumURLValid = checksumURL == null || this.urlPinger.ping(checksumURL);
            if (isDependencyURLValid && isChecksumURLValid) {
                return preResolvedResult;
            }
        }
        Optional<ResolutionResult> result = ((Stream)this.repositories.stream().parallel()).map(enquirer -> enquirer.enquire(dependency)).filter(Objects::nonNull).findFirst();
        String resolvedResult = result.map(ResolutionResult::getDependencyURL).map(Objects::toString).orElse(FAILED_RESOLUTION_MESSAGE);
        LOGGER.debug("Resolved {0} @ {1}", dependency.getArtifactId(), resolvedResult);
        return result.orElse(null);
    }
}

