/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.slimjar.relocation.helper;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.NoSuchAlgorithmException;
import tr.com.infumia.infumialib.slimjar.downloader.strategy.FilePathStrategy;
import tr.com.infumia.infumialib.slimjar.relocation.Relocator;
import tr.com.infumia.infumialib.slimjar.relocation.helper.RelocationHelper;
import tr.com.infumia.infumialib.slimjar.relocation.meta.MetaMediator;
import tr.com.infumia.infumialib.slimjar.relocation.meta.MetaMediatorFactory;
import tr.com.infumia.infumialib.slimjar.resolver.data.Dependency;

public final class VerifyingRelocationHelper
implements RelocationHelper {
    private final MetaMediatorFactory mediatorFactory;
    private final FilePathStrategy outputFilePathStrategy;
    private final Relocator relocator;
    private final String selfHash;

    public VerifyingRelocationHelper(String selfHash, FilePathStrategy outputFilePathStrategy, Relocator relocator, MetaMediatorFactory mediatorFactory) throws URISyntaxException, NoSuchAlgorithmException, IOException {
        this.mediatorFactory = mediatorFactory;
        this.outputFilePathStrategy = outputFilePathStrategy;
        this.relocator = relocator;
        this.selfHash = selfHash;
    }

    @Override
    public File relocate(Dependency dependency, File file) throws IOException, ReflectiveOperationException {
        File relocatedFile = this.outputFilePathStrategy.selectFileFor(dependency);
        MetaMediator metaMediator = this.mediatorFactory.create(relocatedFile.toPath());
        if (relocatedFile.exists()) {
            try {
                String ownerHash = metaMediator.readAttribute("slimjar.owner");
                if (this.selfHash != null && ownerHash != null && this.selfHash.trim().equals(ownerHash.trim())) {
                    return relocatedFile;
                }
            }
            catch (Exception exception) {
                relocatedFile.delete();
            }
        }
        this.relocator.relocate(file, relocatedFile);
        metaMediator.writeAttribute("slimjar.owner", this.selfHash);
        return relocatedFile;
    }
}

