/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.slimjar.downloader.strategy;

import java.io.File;
import java.util.Locale;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import tr.com.infumia.infumialib.slimjar.downloader.strategy.FilePathStrategy;
import tr.com.infumia.infumialib.slimjar.downloader.strategy.FolderedFilePathStrategy;
import tr.com.infumia.infumialib.slimjar.resolver.data.Dependency;

public final class ChecksumFilePathStrategy
implements FilePathStrategy {
    private static final String DEPENDENCY_FILE_FORMAT = "%s/%s/%s/%s/%3$s-%4$s.jar.%5$s";
    private static final Logger LOGGER = Logger.getLogger(FolderedFilePathStrategy.class.getName());
    private final String algorithm;
    private final File rootDirectory;

    private ChecksumFilePathStrategy(File rootDirectory, String algorithm) {
        this.rootDirectory = rootDirectory;
        this.algorithm = algorithm.replaceAll("[ -]", "").toLowerCase(Locale.ENGLISH);
    }

    public static FilePathStrategy createStrategy(File rootDirectory, String algorithm) throws IllegalArgumentException {
        boolean created;
        if (!rootDirectory.exists() && !(created = rootDirectory.mkdirs())) {
            throw new IllegalArgumentException("Could not create specified directory: " + rootDirectory);
        }
        if (!rootDirectory.isDirectory()) {
            throw new IllegalArgumentException("Expecting a directory for download root! " + rootDirectory);
        }
        return new ChecksumFilePathStrategy(rootDirectory, algorithm);
    }

    @Override
    public File selectFileFor(Dependency dependency) {
        String extendedVersion = Optional.ofNullable(dependency.getSnapshotId()).map(s -> "-" + s).orElse("");
        String path = String.format(DEPENDENCY_FILE_FORMAT, this.rootDirectory.getPath(), dependency.getGroupId().replace('.', '/'), dependency.getArtifactId(), dependency.getVersion() + extendedVersion, this.algorithm);
        LOGGER.log(Level.FINEST, "Selected checksum file for " + dependency.getArtifactId() + " at " + path);
        return new File(path);
    }
}

