/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.slimjar.app.builder;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import tr.com.infumia.infumialib.slimjar.app.Application;
import tr.com.infumia.infumialib.slimjar.app.builder.InjectingApplicationBuilder;
import tr.com.infumia.infumialib.slimjar.app.builder.IsolatedApplicationBuilder;
import tr.com.infumia.infumialib.slimjar.app.builder.IsolationConfiguration;
import tr.com.infumia.infumialib.slimjar.downloader.DependencyDownloaderFactory;
import tr.com.infumia.infumialib.slimjar.downloader.URLDependencyDownloaderFactory;
import tr.com.infumia.infumialib.slimjar.downloader.output.DependencyOutputWriterFactory;
import tr.com.infumia.infumialib.slimjar.downloader.strategy.ChecksumFilePathStrategy;
import tr.com.infumia.infumialib.slimjar.downloader.strategy.FilePathStrategy;
import tr.com.infumia.infumialib.slimjar.downloader.verify.ChecksumDependencyVerifierFactory;
import tr.com.infumia.infumialib.slimjar.downloader.verify.DependencyVerifierFactory;
import tr.com.infumia.infumialib.slimjar.downloader.verify.FileChecksumCalculator;
import tr.com.infumia.infumialib.slimjar.downloader.verify.PassthroughDependencyVerifierFactory;
import tr.com.infumia.infumialib.slimjar.injector.DependencyInjector;
import tr.com.infumia.infumialib.slimjar.injector.DependencyInjectorFactory;
import tr.com.infumia.infumialib.slimjar.injector.SimpleDependencyInjectorFactory;
import tr.com.infumia.infumialib.slimjar.injector.helper.InjectionHelperFactory;
import tr.com.infumia.infumialib.slimjar.injector.loader.Injectable;
import tr.com.infumia.infumialib.slimjar.logging.LogDispatcher;
import tr.com.infumia.infumialib.slimjar.logging.MediatingProcessLogger;
import tr.com.infumia.infumialib.slimjar.logging.ProcessLogger;
import tr.com.infumia.infumialib.slimjar.relocation.JarFileRelocatorFactory;
import tr.com.infumia.infumialib.slimjar.relocation.RelocatorFactory;
import tr.com.infumia.infumialib.slimjar.relocation.facade.JarRelocatorFacadeFactory;
import tr.com.infumia.infumialib.slimjar.relocation.facade.ReflectiveJarRelocatorFacadeFactory;
import tr.com.infumia.infumialib.slimjar.relocation.helper.RelocationHelperFactory;
import tr.com.infumia.infumialib.slimjar.relocation.helper.VerifyingRelocationHelperFactory;
import tr.com.infumia.infumialib.slimjar.relocation.meta.FlatFileMetaMediatorFactory;
import tr.com.infumia.infumialib.slimjar.relocation.meta.MetaMediatorFactory;
import tr.com.infumia.infumialib.slimjar.resolver.CachingDependencyResolverFactory;
import tr.com.infumia.infumialib.slimjar.resolver.DependencyResolverFactory;
import tr.com.infumia.infumialib.slimjar.resolver.data.Repository;
import tr.com.infumia.infumialib.slimjar.resolver.enquirer.PingingRepositoryEnquirerFactory;
import tr.com.infumia.infumialib.slimjar.resolver.enquirer.RepositoryEnquirerFactory;
import tr.com.infumia.infumialib.slimjar.resolver.mirrors.MirrorSelector;
import tr.com.infumia.infumialib.slimjar.resolver.mirrors.SimpleMirrorSelector;
import tr.com.infumia.infumialib.slimjar.resolver.pinger.HttpURLPinger;
import tr.com.infumia.infumialib.slimjar.resolver.reader.dependency.DependencyDataProviderFactory;
import tr.com.infumia.infumialib.slimjar.resolver.reader.dependency.ExternalDependencyDataProviderFactory;
import tr.com.infumia.infumialib.slimjar.resolver.reader.dependency.GsonDependencyDataProviderFactory;
import tr.com.infumia.infumialib.slimjar.resolver.reader.facade.GsonFacadeFactory;
import tr.com.infumia.infumialib.slimjar.resolver.reader.facade.ReflectiveGsonFacadeFactory;
import tr.com.infumia.infumialib.slimjar.resolver.reader.resolution.GsonPreResolutionDataProviderFactory;
import tr.com.infumia.infumialib.slimjar.resolver.reader.resolution.PreResolutionDataProviderFactory;
import tr.com.infumia.infumialib.slimjar.resolver.strategy.MavenChecksumPathResolutionStrategy;
import tr.com.infumia.infumialib.slimjar.resolver.strategy.MavenPathResolutionStrategy;
import tr.com.infumia.infumialib.slimjar.resolver.strategy.MavenPomPathResolutionStrategy;
import tr.com.infumia.infumialib.slimjar.resolver.strategy.MavenSnapshotPathResolutionStrategy;
import tr.com.infumia.infumialib.slimjar.resolver.strategy.MediatingPathResolutionStrategy;

public abstract class ApplicationBuilder {
    private static final Path DEFAULT_DOWNLOAD_DIRECTORY;
    private final String applicationName;
    private DependencyDataProviderFactory dataProviderFactory;
    private URL dependencyFileUrl;
    private Path downloadDirectoryPath;
    private DependencyDownloaderFactory downloaderFactory;
    private RepositoryEnquirerFactory enquirerFactory;
    private DependencyInjectorFactory injectorFactory;
    private Collection<Repository> internalRepositories;
    private ProcessLogger logger;
    private MirrorSelector mirrorSelector;
    private DependencyDataProviderFactory moduleDataProviderFactory;
    private PreResolutionDataProviderFactory preResolutionDataProviderFactory;
    private URL preResolutionFileUrl;
    private RelocationHelperFactory relocationHelperFactory;
    private RelocatorFactory relocatorFactory;
    private DependencyResolverFactory resolverFactory;
    private DependencyVerifierFactory verifierFactory;

    protected ApplicationBuilder(String applicationName) {
        this.applicationName = Objects.requireNonNull(applicationName, "Requires non-null application name!");
    }

    public static ApplicationBuilder appending(String name) throws URISyntaxException, ReflectiveOperationException, NoSuchAlgorithmException, IOException {
        return InjectingApplicationBuilder.createAppending(name);
    }

    public static ApplicationBuilder injecting(String name, Injectable injectable) {
        return new InjectingApplicationBuilder(name, injectable);
    }

    public static ApplicationBuilder isolated(String name, IsolationConfiguration config, Object[] args) {
        return new IsolatedApplicationBuilder(name, config, args);
    }

    public final Application build() throws IOException, ReflectiveOperationException, URISyntaxException, NoSuchAlgorithmException {
        MediatingProcessLogger mediatingLogger = LogDispatcher.getMediatingLogger();
        ProcessLogger logger = this.getLogger();
        mediatingLogger.addLogger(logger);
        Application result = this.buildApplication();
        mediatingLogger.removeLogger(logger);
        return result;
    }

    public final ApplicationBuilder dataProviderFactory(DependencyDataProviderFactory dataProviderFactory) {
        this.dataProviderFactory = dataProviderFactory;
        return this;
    }

    public final ApplicationBuilder dependencyFileUrl(URL dependencyFileUrl) {
        this.dependencyFileUrl = dependencyFileUrl;
        return this;
    }

    public final ApplicationBuilder downloadDirectoryPath(Path downloadDirectoryPath) {
        this.downloadDirectoryPath = downloadDirectoryPath;
        return this;
    }

    public final ApplicationBuilder downloaderFactory(DependencyDownloaderFactory downloaderFactory) {
        this.downloaderFactory = downloaderFactory;
        return this;
    }

    public final ApplicationBuilder enquirerFactory(RepositoryEnquirerFactory enquirerFactory) {
        this.enquirerFactory = enquirerFactory;
        return this;
    }

    public final ApplicationBuilder injectorFactory(DependencyInjectorFactory injectorFactory) {
        this.injectorFactory = injectorFactory;
        return this;
    }

    public final ApplicationBuilder internalRepositories(Collection<Repository> repositories) {
        this.internalRepositories = repositories;
        return this;
    }

    public final ApplicationBuilder logger(ProcessLogger logger) {
        this.logger = logger;
        return this;
    }

    public final ApplicationBuilder mirrorSelector(MirrorSelector mirrorSelector) {
        this.mirrorSelector = mirrorSelector;
        return this;
    }

    public final ApplicationBuilder moduleDataProviderFactory(DependencyDataProviderFactory moduleDataProviderFactory) {
        this.moduleDataProviderFactory = moduleDataProviderFactory;
        return this;
    }

    public final ApplicationBuilder preResolutionDataProviderFactory(PreResolutionDataProviderFactory preResolutionDataProviderFactory) {
        this.preResolutionDataProviderFactory = preResolutionDataProviderFactory;
        return this;
    }

    public final ApplicationBuilder preResolutionFileUrl(URL preResolutionFileUrl) {
        this.preResolutionFileUrl = preResolutionFileUrl;
        return this;
    }

    public final ApplicationBuilder relocationHelperFactory(RelocationHelperFactory relocationHelperFactory) {
        this.relocationHelperFactory = relocationHelperFactory;
        return this;
    }

    public final ApplicationBuilder relocatorFactory(RelocatorFactory relocatorFactory) {
        this.relocatorFactory = relocatorFactory;
        return this;
    }

    public final ApplicationBuilder resolverFactory(DependencyResolverFactory resolverFactory) {
        this.resolverFactory = resolverFactory;
        return this;
    }

    public final ApplicationBuilder verifierFactory(DependencyVerifierFactory verifierFactory) {
        this.verifierFactory = verifierFactory;
        return this;
    }

    protected final DependencyInjector createInjector() throws IOException, URISyntaxException, NoSuchAlgorithmException, ReflectiveOperationException {
        InjectionHelperFactory injectionHelperFactory = new InjectionHelperFactory(this.getDownloadDirectoryPath(), this.getRelocatorFactory(), this.getDataProviderFactory(), this.getRelocationHelperFactory(), this.getInjectorFactory(), this.getResolverFactory(), this.getEnquirerFactory(), this.getDownloaderFactory(), this.getVerifierFactory(), this.getMirrorSelector());
        return this.getInjectorFactory().create(injectionHelperFactory);
    }

    protected final String getApplicationName() {
        return this.applicationName;
    }

    protected final DependencyDataProviderFactory getDataProviderFactory() throws URISyntaxException, ReflectiveOperationException, NoSuchAlgorithmException, IOException {
        if (this.dataProviderFactory == null) {
            GsonFacadeFactory gsonFacadeFactory = ReflectiveGsonFacadeFactory.create(this.getDownloadDirectoryPath(), this.getInternalRepositories());
            this.dataProviderFactory = new GsonDependencyDataProviderFactory(gsonFacadeFactory);
        }
        return this.dataProviderFactory;
    }

    protected final URL getDependencyFileUrl() {
        if (this.dependencyFileUrl == null) {
            this.dependencyFileUrl = this.getClass().getClassLoader().getResource("slimjar.json");
        }
        return this.dependencyFileUrl;
    }

    protected final Path getDownloadDirectoryPath() {
        if (this.downloadDirectoryPath == null) {
            this.downloadDirectoryPath = DEFAULT_DOWNLOAD_DIRECTORY;
        }
        return this.downloadDirectoryPath;
    }

    protected final DependencyDownloaderFactory getDownloaderFactory() {
        if (this.downloaderFactory == null) {
            this.downloaderFactory = new URLDependencyDownloaderFactory();
        }
        return this.downloaderFactory;
    }

    protected final RepositoryEnquirerFactory getEnquirerFactory() {
        if (this.enquirerFactory == null) {
            MavenPathResolutionStrategy releaseStrategy = new MavenPathResolutionStrategy();
            MavenSnapshotPathResolutionStrategy snapshotStrategy = new MavenSnapshotPathResolutionStrategy();
            MediatingPathResolutionStrategy resolutionStrategy = new MediatingPathResolutionStrategy(releaseStrategy, snapshotStrategy);
            MavenPomPathResolutionStrategy pomURLCreationStrategy = new MavenPomPathResolutionStrategy();
            MavenChecksumPathResolutionStrategy checksumResolutionStrategy = new MavenChecksumPathResolutionStrategy("SHA-1", resolutionStrategy);
            HttpURLPinger urlPinger = new HttpURLPinger();
            this.enquirerFactory = new PingingRepositoryEnquirerFactory(resolutionStrategy, checksumResolutionStrategy, pomURLCreationStrategy, urlPinger);
        }
        return this.enquirerFactory;
    }

    protected final DependencyInjectorFactory getInjectorFactory() {
        if (this.injectorFactory == null) {
            this.injectorFactory = new SimpleDependencyInjectorFactory();
        }
        return this.injectorFactory;
    }

    protected final Collection<Repository> getInternalRepositories() throws MalformedURLException {
        if (this.internalRepositories == null) {
            this.internalRepositories = Collections.singleton(new Repository(new URL("https://repo1.maven.org/maven2/")));
        }
        return this.internalRepositories;
    }

    protected final ProcessLogger getLogger() {
        if (this.logger == null) {
            this.logger = (msg, args) -> {};
        }
        return this.logger;
    }

    protected final MirrorSelector getMirrorSelector() throws MalformedURLException {
        if (this.mirrorSelector == null) {
            this.mirrorSelector = new SimpleMirrorSelector(this.getInternalRepositories());
        }
        return this.mirrorSelector;
    }

    protected final DependencyDataProviderFactory getModuleDataProviderFactory() throws URISyntaxException, ReflectiveOperationException, NoSuchAlgorithmException, IOException {
        if (this.moduleDataProviderFactory == null) {
            GsonFacadeFactory gsonFacadeFactory = ReflectiveGsonFacadeFactory.create(this.getDownloadDirectoryPath(), this.getInternalRepositories());
            this.moduleDataProviderFactory = new ExternalDependencyDataProviderFactory(gsonFacadeFactory);
        }
        return this.moduleDataProviderFactory;
    }

    protected final PreResolutionDataProviderFactory getPreResolutionDataProviderFactory() throws URISyntaxException, ReflectiveOperationException, NoSuchAlgorithmException, IOException {
        if (this.preResolutionDataProviderFactory == null) {
            GsonFacadeFactory gsonFacadeFactory = ReflectiveGsonFacadeFactory.create(this.getDownloadDirectoryPath(), this.getInternalRepositories());
            this.preResolutionDataProviderFactory = new GsonPreResolutionDataProviderFactory(gsonFacadeFactory);
        }
        return this.preResolutionDataProviderFactory;
    }

    protected final URL getPreResolutionFileUrl() {
        if (this.preResolutionFileUrl == null) {
            this.preResolutionFileUrl = this.getClass().getClassLoader().getResource("slimjar-resolutions.json");
        }
        return this.preResolutionFileUrl;
    }

    protected final RelocationHelperFactory getRelocationHelperFactory() throws NoSuchAlgorithmException, IOException, URISyntaxException {
        if (this.relocationHelperFactory == null) {
            FileChecksumCalculator checksumCalculator = new FileChecksumCalculator("SHA-256");
            FilePathStrategy pathStrategy = FilePathStrategy.createRelocationStrategy(this.getDownloadDirectoryPath().toFile(), this.getApplicationName());
            FlatFileMetaMediatorFactory mediatorFactory = new FlatFileMetaMediatorFactory();
            this.relocationHelperFactory = new VerifyingRelocationHelperFactory(checksumCalculator, pathStrategy, (MetaMediatorFactory)mediatorFactory);
        }
        return this.relocationHelperFactory;
    }

    protected final RelocatorFactory getRelocatorFactory() throws ReflectiveOperationException, NoSuchAlgorithmException, IOException, URISyntaxException {
        if (this.relocatorFactory == null) {
            JarRelocatorFacadeFactory jarRelocatorFacadeFactory = ReflectiveJarRelocatorFacadeFactory.create(this.getDownloadDirectoryPath(), this.getInternalRepositories());
            this.relocatorFactory = new JarFileRelocatorFactory(jarRelocatorFacadeFactory);
        }
        return this.relocatorFactory;
    }

    protected final DependencyResolverFactory getResolverFactory() {
        if (this.resolverFactory == null) {
            HttpURLPinger pinger = new HttpURLPinger();
            this.resolverFactory = new CachingDependencyResolverFactory(pinger);
        }
        return this.resolverFactory;
    }

    protected final DependencyVerifierFactory getVerifierFactory() throws NoSuchAlgorithmException {
        if (this.verifierFactory == null) {
            FilePathStrategy filePathStrategy = ChecksumFilePathStrategy.createStrategy(this.getDownloadDirectoryPath().toFile(), "SHA-1");
            DependencyOutputWriterFactory checksumOutputFactory = new DependencyOutputWriterFactory(filePathStrategy);
            PassthroughDependencyVerifierFactory fallback = new PassthroughDependencyVerifierFactory();
            FileChecksumCalculator checksumCalculator = new FileChecksumCalculator("SHA-1");
            this.verifierFactory = new ChecksumDependencyVerifierFactory(checksumOutputFactory, fallback, checksumCalculator);
        }
        return this.verifierFactory;
    }

    protected abstract Application buildApplication() throws IOException, ReflectiveOperationException, URISyntaxException, NoSuchAlgorithmException;

    static {
        String userHome = System.getProperty("user.home");
        String defaultPath = String.format("%s/.slimjar", userHome);
        DEFAULT_DOWNLOAD_DIRECTORY = new File(defaultPath).toPath();
    }
}

