/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.platform.paper.location;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.infumialib.misc.RandomUtil;
import tr.com.infumia.infumialib.platform.paper.location.LocationUtil;

public final class Cuboid {
    private final double maxX;
    private final double maxY;
    private final double maxZ;
    private final double minX;
    private final double minY;
    private final double minZ;
    @NotNull
    private final World world;
    @NotNull
    private final String worldName;
    @NotNull
    private final UUID worldUniqueId;

    public Cuboid(@NotNull World world, @NotNull Location minimumLocation, @NotNull Location maximumLocation, boolean block) {
        World minWorld = Objects.requireNonNull(minimumLocation.getWorld(), "minimum world");
        World maxWorld = Objects.requireNonNull(maximumLocation.getWorld(), "maximum world");
        Preconditions.checkState((boolean)Objects.equals(minWorld, maxWorld), (String)"%s and %s are not equals!", (Object)minWorld, (Object)maxWorld);
        this.world = world;
        this.worldName = world.getName();
        this.worldUniqueId = world.getUID();
        if (block) {
            this.minX = Math.min(minimumLocation.getBlockX(), maximumLocation.getBlockX());
            this.minY = Math.min(minimumLocation.getBlockY(), maximumLocation.getBlockY());
            this.minZ = Math.min(minimumLocation.getBlockZ(), maximumLocation.getBlockZ());
            this.maxX = Math.max(minimumLocation.getBlockX(), maximumLocation.getBlockX());
            this.maxY = Math.max(minimumLocation.getBlockY(), maximumLocation.getBlockY());
            this.maxZ = Math.max(minimumLocation.getBlockZ(), maximumLocation.getBlockZ());
        } else {
            this.minX = Math.min(minimumLocation.getX(), maximumLocation.getX());
            this.minY = Math.min(minimumLocation.getY(), maximumLocation.getY());
            this.minZ = Math.min(minimumLocation.getZ(), maximumLocation.getZ());
            this.maxX = Math.max(minimumLocation.getX(), maximumLocation.getX());
            this.maxY = Math.max(minimumLocation.getY(), maximumLocation.getY());
            this.maxZ = Math.max(minimumLocation.getZ(), maximumLocation.getZ());
        }
    }

    public Cuboid(@NotNull Location minimumLocation, @NotNull Location maximumLocation, boolean block) {
        this(LocationUtil.validWorld(minimumLocation), minimumLocation, maximumLocation, block);
    }

    public Cuboid(@NotNull Location minimumLocation, @NotNull Location maximumLocation) {
        this(minimumLocation, maximumLocation, false);
    }

    public Cuboid(@NotNull World world, @NotNull Location minimumLocation, @NotNull Location maximumLocation) {
        this(world, minimumLocation, maximumLocation, false);
    }

    @NotNull
    public List<Block> blocks() {
        this.checkWorldNullability();
        ArrayList<Block> result = new ArrayList<Block>();
        this.forEachXYZ(location -> result.add(location.getBlock()));
        return result;
    }

    @NotNull
    public Location center() {
        this.checkWorldNullability();
        return new Location(this.world, this.minX + (this.maxX - this.minX) / 2.0, this.minY + (this.maxY - this.minY) / 2.0, this.minZ + (this.maxZ - this.minZ) / 2.0);
    }

    @NotNull
    public Location centerBottom() {
        this.checkWorldNullability();
        return new Location(this.world, this.minX + (this.maxX - this.minX) / 2.0, this.minY, this.minZ + (this.maxZ - this.minZ) / 2.0);
    }

    @NotNull
    public Location centerBottomPlus() {
        this.checkWorldNullability();
        double x = this.minX + (this.maxX - this.minX) / 2.0 + 0.5;
        double z = this.minZ + (this.maxZ - this.minZ) / 2.0 + 0.5;
        return new Location(this.world, x, this.minY, z);
    }

    @NotNull
    public Location centerHighestBottom() {
        this.checkWorldNullability();
        double x = this.minX + (this.maxX - this.minX) / 2.0;
        double z = this.minZ + (this.maxZ - this.minZ) / 2.0;
        return new Location(this.world, x, (double)this.world.getHighestBlockAt((int)x, (int)z).getY(), z);
    }

    @NotNull
    public Location centerHighestBottomUpFloor() {
        this.checkWorldNullability();
        double x = this.minX + (this.maxX - this.minX) / 2.0;
        double z = this.minZ + (this.maxZ - this.minZ) / 2.0;
        return new Location(this.world, (double)((int)x), (double)(this.world.getHighestBlockAt((int)x, (int)z).getY() + 1), (double)((int)z));
    }

    public void forEachXYZ(@NotNull Consumer<Location> consumer) {
        this.checkWorldNullability();
        for (double x = this.minX; x <= this.maxX; x += 1.0) {
            for (double y = this.minY; y <= this.maxY; y += 1.0) {
                for (double z = this.minZ; z <= this.maxZ; z += 1.0) {
                    consumer.accept(new Location(this.world, x, y, z));
                }
            }
        }
    }

    public boolean isInX(@NotNull Location location) {
        return location.getX() >= this.minX && location.getX() <= this.maxX;
    }

    public boolean isInXY(@NotNull Location location) {
        return this.isInX(location) && this.isInY(location);
    }

    public boolean isInXYZ(@NotNull Location location) {
        return this.isInX(location) && this.isInY(location) && this.isInZ(location);
    }

    public boolean isInXZ(@NotNull Location location) {
        return this.isInX(location) && this.isInZ(location);
    }

    public boolean isInY(@NotNull Location location) {
        return this.minY <= location.getY() && location.getY() <= this.maxY;
    }

    public boolean isInYZ(@NotNull Location location) {
        return this.isInY(location) && this.isInZ(location);
    }

    public boolean isInZ(@NotNull Location location) {
        return this.minZ <= location.getZ() && location.getZ() <= this.maxZ;
    }

    @NotNull
    public List<Location> locations() {
        this.checkWorldNullability();
        ArrayList<Location> result = new ArrayList<Location>();
        this.forEachXYZ(result::add);
        return result;
    }

    @NotNull
    public List<Block> randomBlocks(int limit, boolean duplicate) {
        return RandomUtil.chooseRandoms(this.blocks(), limit, duplicate);
    }

    @NotNull
    public List<Location> randomLocations(int limit, boolean duplicate) {
        return RandomUtil.chooseRandoms(this.locations(), limit, duplicate);
    }

    public void removeAll() {
        this.blocks().forEach(block -> block.setType(Material.AIR));
    }

    public void set(@NotNull Material material) {
        this.blocks().forEach(block -> block.setType(material));
    }

    private void checkWorldNullability() {
        Objects.requireNonNull(Bukkit.getWorld((UUID)this.worldUniqueId), "world");
    }

    public String toString() {
        return "Cuboid(maxX=" + this.getMaxX() + ", maxY=" + this.getMaxY() + ", maxZ=" + this.getMaxZ() + ", minX=" + this.getMinX() + ", minY=" + this.getMinY() + ", minZ=" + this.getMinZ() + ", worldName=" + this.getWorldName() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Cuboid)) {
            return false;
        }
        Cuboid other = (Cuboid)o;
        if (Double.compare(this.getMaxX(), other.getMaxX()) != 0) {
            return false;
        }
        if (Double.compare(this.getMaxY(), other.getMaxY()) != 0) {
            return false;
        }
        if (Double.compare(this.getMaxZ(), other.getMaxZ()) != 0) {
            return false;
        }
        if (Double.compare(this.getMinX(), other.getMinX()) != 0) {
            return false;
        }
        if (Double.compare(this.getMinY(), other.getMinY()) != 0) {
            return false;
        }
        if (Double.compare(this.getMinZ(), other.getMinZ()) != 0) {
            return false;
        }
        String this$worldName = this.getWorldName();
        String other$worldName = other.getWorldName();
        return !(this$worldName == null ? other$worldName != null : !this$worldName.equals(other$worldName));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $maxX = Double.doubleToLongBits(this.getMaxX());
        result = result * 59 + (int)($maxX >>> 32 ^ $maxX);
        long $maxY = Double.doubleToLongBits(this.getMaxY());
        result = result * 59 + (int)($maxY >>> 32 ^ $maxY);
        long $maxZ = Double.doubleToLongBits(this.getMaxZ());
        result = result * 59 + (int)($maxZ >>> 32 ^ $maxZ);
        long $minX = Double.doubleToLongBits(this.getMinX());
        result = result * 59 + (int)($minX >>> 32 ^ $minX);
        long $minY = Double.doubleToLongBits(this.getMinY());
        result = result * 59 + (int)($minY >>> 32 ^ $minY);
        long $minZ = Double.doubleToLongBits(this.getMinZ());
        result = result * 59 + (int)($minZ >>> 32 ^ $minZ);
        String $worldName = this.getWorldName();
        result = result * 59 + ($worldName == null ? 43 : $worldName.hashCode());
        return result;
    }

    public double getMaxX() {
        return this.maxX;
    }

    public double getMaxY() {
        return this.maxY;
    }

    public double getMaxZ() {
        return this.maxZ;
    }

    public double getMinX() {
        return this.minX;
    }

    public double getMinY() {
        return this.minY;
    }

    public double getMinZ() {
        return this.minZ;
    }

    @NotNull
    public String getWorldName() {
        return this.worldName;
    }
}

