/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.platform.paper.itemstack;

import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.World;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.MapMeta;
import org.bukkit.map.MapView;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;
import tr.com.infumia.infumialib.platform.paper.itemstack.ItemStackBuilder;
import tr.com.infumia.infumialib.platform.paper.version.BukkitVersion;

public final class MapItemBuilder
extends ItemStackBuilder<MapMeta, MapItemBuilder> {
    private MapItemBuilder(@NotNull MapMeta itemMeta, @NotNull ItemStack itemStack) {
        super(itemMeta, itemStack);
    }

    @NotNull
    public static MapItemBuilder from(@NotNull MapMeta itemMeta, @NotNull ItemStack itemStack) {
        return new MapItemBuilder(itemMeta, itemStack);
    }

    @NotNull
    public MapItemBuilder color(@Nullable Color color) {
        if (BukkitVersion.MAJOR >= 11) {
            ((MapMeta)this.itemMeta()).setColor(color);
        }
        return this.self();
    }

    @Override
    public void deserialize(@NotNull ConfigurationNode node) throws SerializationException {
        super.deserialize(node);
        ConfigurationNode mapNode = node.node(new Object[]{"map"});
        boolean scaling = mapNode.node(new Object[]{"scaling"}).getBoolean();
        this.scaling(scaling);
        if (BukkitVersion.MAJOR >= 11) {
            Optional.ofNullable(mapNode.node(new Object[]{"location"}).getString()).ifPresent(this::locationName);
            Optional.ofNullable((Color)mapNode.node(new Object[]{"color"}).get(Color.class)).ifPresent(this::color);
        }
        if (BukkitVersion.MAJOR >= 13) {
            this.mapId(mapNode.node(new Object[]{"map-id"}).getInt());
        }
        if (BukkitVersion.MAJOR >= 14) {
            ConfigurationNode viewNode = mapNode.node(new Object[]{"view"});
            World world = (World)viewNode.node(new Object[]{"world"}).get(World.class);
            if (world != null) {
                MapView mapView = Bukkit.createMap((World)world);
                ConfigurationNode centerNode = viewNode.node(new Object[]{"center"});
                mapView.setWorld(world);
                mapView.setScale((MapView.Scale)viewNode.node(new Object[]{"scale"}).get(MapView.Scale.class, (Object)MapView.Scale.NORMAL));
                mapView.setLocked(viewNode.node(new Object[]{"locked"}).getBoolean());
                mapView.setTrackingPosition(viewNode.node(new Object[]{"tracking-position"}).getBoolean());
                mapView.setUnlimitedTracking(viewNode.node(new Object[]{"unlimited-tracking"}).getBoolean());
                mapView.setCenterX(centerNode.node(new Object[]{"x"}).getInt());
                mapView.setCenterZ(centerNode.node(new Object[]{"z"}).getInt());
                this.mapView(mapView);
            }
        }
    }

    @Override
    public void serialize(@NotNull ConfigurationNode node) throws SerializationException {
        super.serialize(node);
        MapMeta itemMeta = (MapMeta)this.itemMeta();
        ConfigurationNode mapNode = node.node(new Object[]{"map"});
        mapNode.node(new Object[]{"scaling"}).set((Object)itemMeta.isScaling());
        if (BukkitVersion.MAJOR >= 11) {
            Color color;
            if (itemMeta.hasLocationName()) {
                mapNode.node(new Object[]{"location"}).set((Object)itemMeta.getLocationName());
            }
            if ((color = itemMeta.getColor()) != null) {
                mapNode.node(new Object[]{"color"}).set((Object)color);
            }
        }
        if (BukkitVersion.MAJOR >= 13) {
            mapNode.node(new Object[]{"map-id"}).set((Object)itemMeta.getMapId());
        }
        if (BukkitVersion.MAJOR >= 14) {
            MapView mapView = itemMeta.getMapView();
            if (itemMeta.hasMapView() && mapView != null) {
                ConfigurationNode viewNode = mapNode.node(new Object[]{"view"});
                ConfigurationNode centerNode = viewNode.node(new Object[]{"center"});
                viewNode.node(new Object[]{"scale"}).set((Object)mapView.getScale().toString());
                World world = mapView.getWorld();
                if (world != null) {
                    viewNode.node(new Object[]{"world"}).set((Object)world);
                }
                viewNode.node(new Object[]{"locked"}).set((Object)mapView.isLocked());
                viewNode.node(new Object[]{"tracking-position"}).set((Object)mapView.isTrackingPosition());
                viewNode.node(new Object[]{"unlimited-tracking"}).set((Object)mapView.isUnlimitedTracking());
                centerNode.node(new Object[]{"x"}).set((Object)mapView.getCenterX());
                centerNode.node(new Object[]{"z"}).set((Object)mapView.getCenterZ());
            }
        }
    }

    @NotNull
    public MapItemBuilder locationName(@Nullable String name) {
        if (BukkitVersion.MAJOR >= 11) {
            ((MapMeta)this.itemMeta()).setLocationName(name);
        }
        return this.self();
    }

    @Deprecated
    @NotNull
    public MapItemBuilder mapId(int id) {
        if (BukkitVersion.MAJOR >= 13) {
            ((MapMeta)this.itemMeta()).setMapId(id);
        }
        return this.self();
    }

    @NotNull
    public MapItemBuilder mapView(@NotNull MapView mapView) {
        if (BukkitVersion.MAJOR >= 14) {
            ((MapMeta)this.itemMeta()).setMapView(mapView);
        }
        return this.self();
    }

    @NotNull
    public MapItemBuilder scaling(boolean scaling) {
        ((MapMeta)this.itemMeta()).setScaling(scaling);
        return this.self();
    }

    @Override
    @NotNull
    public MapItemBuilder self() {
        return this;
    }
}

