/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.platform.paper.element;

import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;
import tr.com.infumia.infumialib.platform.paper.element.PlaceType;
import tr.com.infumia.infumialib.platform.paper.element.types.PtFill;
import tr.com.infumia.infumialib.platform.paper.element.types.PtFillBorders;
import tr.com.infumia.infumialib.platform.paper.element.types.PtFillColumn;
import tr.com.infumia.infumialib.platform.paper.element.types.PtFillEmpties;
import tr.com.infumia.infumialib.platform.paper.element.types.PtFillPattern;
import tr.com.infumia.infumialib.platform.paper.element.types.PtFillPatternStart;
import tr.com.infumia.infumialib.platform.paper.element.types.PtFillPatternStartIndex;
import tr.com.infumia.infumialib.platform.paper.element.types.PtFillRectFromTo;
import tr.com.infumia.infumialib.platform.paper.element.types.PtFillRectIndex;
import tr.com.infumia.infumialib.platform.paper.element.types.PtFillRepeatingPattern;
import tr.com.infumia.infumialib.platform.paper.element.types.PtFillRepeatingPatternStart;
import tr.com.infumia.infumialib.platform.paper.element.types.PtFillRepeatingPatternStartIndex;
import tr.com.infumia.infumialib.platform.paper.element.types.PtFillRow;
import tr.com.infumia.infumialib.platform.paper.element.types.PtFillSquareFromTo;
import tr.com.infumia.infumialib.platform.paper.element.types.PtFillSquareIndex;
import tr.com.infumia.infumialib.platform.paper.element.types.PtInsert;
import tr.com.infumia.infumialib.platform.paper.element.types.PtInsertIndex;
import tr.com.infumia.infumialib.platform.paper.element.types.PtNone;
import tr.com.infumia.infumialib.platform.paper.element.types.PtSlots;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum PlaceTypes {
    FILL("fill"){

        @Override
        @NotNull
        public PlaceType deserialize(@NotNull ConfigurationNode node) throws SerializationException {
            return PtFill.INSTANCE;
        }
    }
    ,
    FILL_BORDERS("fill-borders"){

        @Override
        @NotNull
        public PlaceType deserialize(@NotNull ConfigurationNode node) throws SerializationException {
            return PtFillBorders.INSTANCE;
        }
    }
    ,
    FILL_COLUMN("fill-column"){

        @Override
        @NotNull
        public PlaceType deserialize(@NotNull ConfigurationNode node) throws SerializationException {
            return new PtFillColumn(node.node(new Object[]{"column"}).getInt());
        }
    }
    ,
    FILL_EMPTIES("fill-empties"){

        @Override
        @NotNull
        public PlaceType deserialize(@NotNull ConfigurationNode node) throws SerializationException {
            return PtFillEmpties.INSTANCE;
        }
    }
    ,
    FILL_PATTERN("fill-pattern"){

        @Override
        @NotNull
        public PlaceType deserialize(@NotNull ConfigurationNode node) throws SerializationException {
            return new PtFillPattern(node.node(new Object[]{"wrap-around"}).getBoolean(), node.node(new Object[]{"pattern"}).getList(String.class, Collections.emptyList()));
        }
    }
    ,
    FILL_PATTERN_START("fill-pattern-start"){

        @Override
        @NotNull
        public PlaceType deserialize(@NotNull ConfigurationNode node) throws SerializationException {
            return new PtFillPatternStart(node.node(new Object[]{"wrap-around"}).getBoolean(), node.node(new Object[]{"pattern"}).getList(String.class, Collections.emptyList()), node.node(new Object[]{"start-row"}).getInt(), node.node(new Object[]{"start-column"}).getInt());
        }
    }
    ,
    FILL_PATTERN_START_INDEX("fill-pattern-start-index"){

        @Override
        @NotNull
        public PlaceType deserialize(@NotNull ConfigurationNode node) throws SerializationException {
            return new PtFillPatternStartIndex(node.node(new Object[]{"wrap-around"}).getBoolean(), node.node(new Object[]{"pattern"}).getList(String.class, Collections.emptyList()), node.node(new Object[]{"start-index"}).getInt());
        }
    }
    ,
    FILL_RECT_FROM_TO("fill-react-from-to"){

        @Override
        @NotNull
        public PlaceType deserialize(@NotNull ConfigurationNode node) throws SerializationException {
            return new PtFillRectFromTo(node.node(new Object[]{"from-row"}).getInt(), node.node(new Object[]{"from-column"}).getInt(), node.node(new Object[]{"to-row"}).getInt(), node.node(new Object[]{"from-column"}).getInt());
        }
    }
    ,
    FILL_RECT_INDEX("fill-rect-index"){

        @Override
        @NotNull
        public PlaceType deserialize(@NotNull ConfigurationNode node) throws SerializationException {
            return new PtFillRectIndex(node.node(new Object[]{"from-index"}).getInt(), node.node(new Object[]{"to-index"}).getInt());
        }
    }
    ,
    FILL_REPEATING_PATTERN("fill-repeating-pattern"){

        @Override
        @NotNull
        public PlaceType deserialize(@NotNull ConfigurationNode node) throws SerializationException {
            return new PtFillRepeatingPattern(node.node(new Object[]{"wrap-around"}).getBoolean(), node.node(new Object[]{"pattern"}).getList(String.class, Collections.emptyList()));
        }
    }
    ,
    FILL_REPEATING_PATTERN_START("fill-repeating-pattern-start"){

        @Override
        @NotNull
        public PlaceType deserialize(@NotNull ConfigurationNode node) throws SerializationException {
            return new PtFillRepeatingPatternStart(node.node(new Object[]{"wrap-around"}).getBoolean(), node.node(new Object[]{"pattern"}).getList(String.class, Collections.emptyList()), node.node(new Object[]{"start-row"}).getInt(), node.node(new Object[]{"start-column"}).getInt(), node.node(new Object[]{"end-row"}).getInt(), node.node(new Object[]{"end-column"}).getInt());
        }
    }
    ,
    FILL_REPEATING_PATTERN_START_INDEX("fill-repeating-pattern-start-index"){

        @Override
        @NotNull
        public PlaceType deserialize(@NotNull ConfigurationNode node) throws SerializationException {
            return new PtFillRepeatingPatternStartIndex(node.node(new Object[]{"wrap-around"}).getBoolean(), node.node(new Object[]{"pattern"}).getList(String.class, Collections.emptyList()), node.node(new Object[]{"start-index"}).getInt(), node.node(new Object[]{"end-index"}).getInt());
        }
    }
    ,
    FILL_ROW("fill-row"){

        @Override
        @NotNull
        public PlaceType deserialize(@NotNull ConfigurationNode node) throws SerializationException {
            return new PtFillRow(node.node(new Object[]{"row"}).getInt());
        }
    }
    ,
    FILL_SQUARE_FROM_TO("fill-square-from-to"){

        @Override
        @NotNull
        public PlaceType deserialize(@NotNull ConfigurationNode node) throws SerializationException {
            return new PtFillSquareFromTo(node.node(new Object[]{"from-row"}).getInt(), node.node(new Object[]{"from-column"}).getInt(), node.node(new Object[]{"to-row"}).getInt(), node.node(new Object[]{"to-column"}).getInt());
        }
    }
    ,
    FILL_SQUARE_INDEX("fill-square-index"){

        @Override
        @NotNull
        public PlaceType deserialize(@NotNull ConfigurationNode node) throws SerializationException {
            return new PtFillSquareIndex(node.node(new Object[]{"from-index"}).getInt(), node.node(new Object[]{"to-index"}).getInt());
        }
    }
    ,
    INSERT("insert"){

        @Override
        @NotNull
        public PlaceType deserialize(@NotNull ConfigurationNode node) throws SerializationException {
            return new PtInsert(node.node(new Object[]{"row"}).getInt(), node.node(new Object[]{"column"}).getInt());
        }
    }
    ,
    INSERT_INDEX("insert-index"){

        @Override
        @NotNull
        public PlaceType deserialize(@NotNull ConfigurationNode node) throws SerializationException {
            return new PtInsertIndex(node.node(new Object[]{"index"}).getInt());
        }
    }
    ,
    SLOTS("slots"){

        @Override
        @NotNull
        public PlaceType deserialize(@NotNull ConfigurationNode node) throws SerializationException {
            return new PtSlots(node.node(new Object[]{"slots"}).getList(Integer.TYPE, Collections.emptyList()));
        }
    }
    ,
    NONE("none"){

        @Override
        @NotNull
        public PlaceType deserialize(@NotNull ConfigurationNode node) throws SerializationException {
            return PtNone.INSTANCE;
        }
    };

    private static final PlaceTypes[] CACHE;
    @NotNull
    private final String type;

    @NotNull
    public static Optional<PlaceTypes> byType(@NotNull String type) {
        return Arrays.stream(CACHE).filter(pt -> pt.type.equalsIgnoreCase(type)).findFirst();
    }

    @NotNull
    public abstract PlaceType deserialize(@NotNull ConfigurationNode var1) throws SerializationException;

    @NotNull
    public String type() {
        return this.type;
    }

    private PlaceTypes(String type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.type = type;
    }

    static {
        CACHE = PlaceTypes.values();
    }
}

