/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.platform.paper;

import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Paths;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import org.bukkit.plugin.java.JavaPlugin;
import tr.com.infumia.infumialib.platform.paper.Initializer;
import tr.com.infumia.infumialib.slimjar.app.builder.ApplicationBuilder;
import tr.com.infumia.infumialib.slimjar.logging.ProcessLogger;

public final class InfumiaLib
extends JavaPlugin {
    public void loadFiles() {
        Initializer.loadFiles(this);
    }

    public void onLoad() {
        this.loadDependencies();
        Initializer.load(this);
    }

    public void onEnable() {
        Initializer.enable(this);
    }

    private void loadDependencies() {
        this.getSLF4JLogger().info("Loading dependencies, this might take a while...");
        try {
            ApplicationBuilder.appending("InfumiaLibrary").logger(new ProcessLogger(){

                @Override
                public void debug(String message, Object ... args) {
                    InfumiaLib.this.getSLF4JLogger().debug(MessageFormat.format(message, args));
                }

                @Override
                public void log(String message, Object ... args) {
                    InfumiaLib.this.getSLF4JLogger().info(MessageFormat.format(message, args));
                }
            }).downloadDirectoryPath(Paths.get(this.getDataFolder().getAbsolutePath(), new String[0]).resolve("libs")).build();
        }
        catch (IOException | ReflectiveOperationException | URISyntaxException | NoSuchAlgorithmException e) {
            this.getSLF4JLogger().error(String.format("%s-v%s", ((Object)((Object)this)).getClass().getSimpleName(), this.getDescription().getVersion()), (Throwable)e);
            this.getSLF4JLogger().error("Infumia Library failed to load its dependencies correctly!");
            this.getSLF4JLogger().error("This error should be reported at https://github.com/Infumia/InfumiaLib/issues");
            this.onDisable();
        }
    }
}

