/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.slimjar.injector.helper;

import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Map;
import tr.com.infumia.infumialib.slimjar.downloader.DependencyDownloader;
import tr.com.infumia.infumialib.slimjar.downloader.DependencyDownloaderFactory;
import tr.com.infumia.infumialib.slimjar.downloader.output.DependencyOutputWriterFactory;
import tr.com.infumia.infumialib.slimjar.downloader.strategy.FilePathStrategy;
import tr.com.infumia.infumialib.slimjar.downloader.verify.DependencyVerifierFactory;
import tr.com.infumia.infumialib.slimjar.injector.DependencyInjectorFactory;
import tr.com.infumia.infumialib.slimjar.injector.helper.InjectionHelper;
import tr.com.infumia.infumialib.slimjar.relocation.Relocator;
import tr.com.infumia.infumialib.slimjar.relocation.RelocatorFactory;
import tr.com.infumia.infumialib.slimjar.relocation.helper.RelocationHelper;
import tr.com.infumia.infumialib.slimjar.relocation.helper.RelocationHelperFactory;
import tr.com.infumia.infumialib.slimjar.resolver.DependencyResolver;
import tr.com.infumia.infumialib.slimjar.resolver.DependencyResolverFactory;
import tr.com.infumia.infumialib.slimjar.resolver.ResolutionResult;
import tr.com.infumia.infumialib.slimjar.resolver.data.DependencyData;
import tr.com.infumia.infumialib.slimjar.resolver.data.Repository;
import tr.com.infumia.infumialib.slimjar.resolver.enquirer.RepositoryEnquirerFactory;
import tr.com.infumia.infumialib.slimjar.resolver.mirrors.MirrorSelector;
import tr.com.infumia.infumialib.slimjar.resolver.reader.dependency.DependencyDataProviderFactory;

public final class InjectionHelperFactory {
    private final Path downloadDirectoryPath;
    private final DependencyDownloaderFactory downloaderFactory;
    private final RepositoryEnquirerFactory enquirerFactory;
    private final MirrorSelector mirrorSelector;
    private final RelocationHelperFactory relocationHelperFactory;
    private final RelocatorFactory relocatorFactory;
    private final DependencyResolverFactory resolverFactory;
    private final DependencyVerifierFactory verifier;

    public InjectionHelperFactory(Path downloadDirectoryPath, RelocatorFactory relocatorFactory, DependencyDataProviderFactory dataProviderFactory, RelocationHelperFactory relocationHelperFactory, DependencyInjectorFactory injectorFactory, DependencyResolverFactory resolverFactory, RepositoryEnquirerFactory enquirerFactory, DependencyDownloaderFactory downloaderFactory, DependencyVerifierFactory verifier, MirrorSelector mirrorSelector) {
        this.downloadDirectoryPath = downloadDirectoryPath;
        this.relocatorFactory = relocatorFactory;
        this.relocationHelperFactory = relocationHelperFactory;
        this.resolverFactory = resolverFactory;
        this.enquirerFactory = enquirerFactory;
        this.downloaderFactory = downloaderFactory;
        this.verifier = verifier;
        this.mirrorSelector = mirrorSelector;
    }

    public InjectionHelper create(DependencyData data, Map<String, ResolutionResult> preResolvedResults) throws IOException, NoSuchAlgorithmException, URISyntaxException {
        Collection<Repository> repositories = this.mirrorSelector.select(data.getRepositories(), data.getMirrors());
        Relocator relocator = this.relocatorFactory.create(data.getRelocations());
        RelocationHelper relocationHelper = this.relocationHelperFactory.create(relocator);
        FilePathStrategy filePathStrategy = FilePathStrategy.createDefault(this.downloadDirectoryPath.toFile());
        DependencyOutputWriterFactory outputWriterFactory = new DependencyOutputWriterFactory(filePathStrategy);
        DependencyResolver resolver = this.resolverFactory.create(repositories, preResolvedResults, this.enquirerFactory);
        DependencyDownloader downloader = this.downloaderFactory.create(outputWriterFactory, resolver, this.verifier.create(resolver));
        return new InjectionHelper(downloader, relocationHelper);
    }
}

