/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.platform.paper.misc;

import com.cryptomorin.xseries.messages.Titles;
import java.util.Map;
import java.util.function.UnaryOperator;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.configurate.objectmapping.ConfigSerializable;
import org.spongepowered.configurate.objectmapping.meta.Setting;
import tr.com.infumia.infumialib.misc.Texts;

@ConfigSerializable
public final class SentTitle {
    @Setting
    private int fadeIn;
    @Setting
    private int fadeOut;
    @Setting
    private int stay;
    @Setting
    @Nullable
    private String subtitle;
    @Setting
    @Nullable
    private String title;

    public SentTitle(@Nullable String title, @Nullable String subtitle, int fadeIn, int stay, int fadeOut) {
        this.title = title;
        this.subtitle = subtitle;
        this.fadeIn = fadeIn;
        this.stay = stay;
        this.fadeOut = fadeOut;
    }

    @SafeVarargs
    public final void send(@NotNull Player player, Map.Entry<String, Object> ... entries) {
        Titles.sendTitle((Player)player, (int)this.fadeIn, (int)this.stay, (int)this.fadeOut, (String)Texts.replace(this.title, entries), (String)Texts.replace(this.subtitle, entries));
    }

    @SafeVarargs
    public final void send(@NotNull Player player, @NotNull UnaryOperator<String> title, @NotNull UnaryOperator<String> subTitle, Map.Entry<String, Object> ... entries) {
        Titles.sendTitle((Player)player, (int)this.fadeIn, (int)this.stay, (int)this.fadeOut, (String)Texts.replace(this.title == null ? null : (String)title.apply(this.title), entries), (String)Texts.replace(this.subtitle == null ? null : (String)subTitle.apply(this.subtitle), entries));
    }

    @NotNull
    public String subtitleOrEmpty() {
        return this.subtitle == null ? "" : this.subtitle;
    }

    @NotNull
    public String titleOrEmpty() {
        return this.title == null ? "" : this.title;
    }

    @NotNull
    public SentTitle valueOfSubtitle(@Nullable String subtitle) {
        return new SentTitle(this.title, subtitle, this.fadeIn, this.stay, this.fadeOut);
    }

    @NotNull
    public SentTitle valueOfTitle(@Nullable String title) {
        return new SentTitle(title, this.subtitle, this.fadeIn, this.stay, this.fadeOut);
    }

    public int fadeIn() {
        return this.fadeIn;
    }

    public int fadeOut() {
        return this.fadeOut;
    }

    public int stay() {
        return this.stay;
    }

    @Nullable
    public String subtitle() {
        return this.subtitle;
    }

    @Nullable
    public String title() {
        return this.title;
    }

    public SentTitle fadeIn(int fadeIn) {
        this.fadeIn = fadeIn;
        return this;
    }

    public SentTitle fadeOut(int fadeOut) {
        this.fadeOut = fadeOut;
        return this;
    }

    public SentTitle stay(int stay) {
        this.stay = stay;
        return this;
    }

    public SentTitle subtitle(@Nullable String subtitle) {
        this.subtitle = subtitle;
        return this;
    }

    public SentTitle title(@Nullable String title) {
        this.title = title;
        return this;
    }

    public SentTitle() {
    }
}

