/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.platform.paper.itemstack;

import java.util.Locale;
import java.util.Optional;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.SpawnEggMeta;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;
import tr.com.infumia.infumialib.platform.paper.itemstack.ItemStackBuilder;

public final class SpawnEggItemBuilder
extends ItemStackBuilder<SpawnEggMeta, SpawnEggItemBuilder> {
    private SpawnEggItemBuilder(@NotNull SpawnEggMeta itemMeta, @NotNull ItemStack itemStack) {
        super(itemMeta, itemStack);
    }

    @NotNull
    public static SpawnEggItemBuilder from(@NotNull SpawnEggMeta itemMeta, @NotNull ItemStack itemStack) {
        return new SpawnEggItemBuilder(itemMeta, itemStack);
    }

    @Override
    public void deserialize(@NotNull ConfigurationNode node) throws SerializationException {
        super.deserialize(node);
        Optional.ofNullable(node.node(new Object[]{"creature"}).getString()).ifPresent(this::spawnedType);
    }

    @Override
    public void serialize(@NotNull ConfigurationNode node) throws SerializationException {
        super.serialize(node);
        String name = ((SpawnEggMeta)this.itemMeta()).getSpawnedType().getName();
        if (name != null) {
            node.node(new Object[]{"creature"}).set((Object)name);
        }
    }

    @Override
    @NotNull
    public SpawnEggItemBuilder self() {
        return this;
    }

    @Deprecated
    @NotNull
    public SpawnEggItemBuilder spawnedType(@NotNull String type) {
        EntityType entityType;
        try {
            entityType = EntityType.valueOf((String)type.toUpperCase(Locale.ROOT));
        }
        catch (Exception e) {
            entityType = EntityType.BAT;
        }
        return this.spawnedType(entityType);
    }

    @Deprecated
    @NotNull
    public SpawnEggItemBuilder spawnedType(@NotNull EntityType type) {
        ((SpawnEggMeta)this.itemMeta()).setSpawnedType(type);
        return this.self();
    }
}

