/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.platform.paper.itemstack;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;
import tr.com.infumia.infumialib.platform.paper.itemstack.ItemStackBuilder;
import tr.com.infumia.infumialib.platform.paper.version.BukkitVersion;

public final class BookItemBuilder
extends ItemStackBuilder<BookMeta, BookItemBuilder> {
    private BookItemBuilder(@NotNull BookMeta itemMeta, @NotNull ItemStack itemStack) {
        super(itemMeta, itemStack);
    }

    @NotNull
    public static BookItemBuilder from(@NotNull BookMeta itemMeta, @NotNull ItemStack itemStack) {
        return new BookItemBuilder(itemMeta, itemStack);
    }

    @NotNull
    public BookItemBuilder addPages(String ... list) {
        ((BookMeta)this.itemMeta()).addPage(list);
        return this.self();
    }

    @NotNull
    public BookItemBuilder author(@Nullable String author) {
        ((BookMeta)this.itemMeta()).setAuthor(author);
        return this.self();
    }

    @Override
    public void deserialize(@NotNull ConfigurationNode node) throws SerializationException {
        super.deserialize(node);
        ConfigurationNode booksNode = node.node(new Object[]{"book"});
        String title = booksNode.node(new Object[]{"title"}).getString();
        String author = booksNode.node(new Object[]{"author"}).getString();
        List pages = booksNode.node(new Object[]{"pages"}).getList(String.class, Collections.emptyList());
        this.title(title);
        this.author(author);
        this.pages(pages);
        if (BukkitVersion.MAJOR >= 10) {
            Optional.ofNullable(booksNode.node(new Object[]{"generation"}).getString()).ifPresent(generationString -> {
                BookMeta.Generation generation;
                try {
                    generation = BookMeta.Generation.valueOf((String)generationString);
                }
                catch (Exception e) {
                    generation = null;
                }
                this.generation(generation);
            });
        }
    }

    @Override
    public void serialize(@NotNull ConfigurationNode node) throws SerializationException {
        BookMeta.Generation generation;
        super.serialize(node);
        BookMeta itemMeta = (BookMeta)this.itemMeta();
        ConfigurationNode booksNode = node.node(new Object[]{"book"});
        if (itemMeta.hasAuthor()) {
            booksNode.node(new Object[]{"title"}).set((Object)itemMeta.getTitle());
        }
        if (itemMeta.hasAuthor()) {
            booksNode.node(new Object[]{"author", itemMeta.getAuthor()});
        }
        if (BukkitVersion.MAJOR >= 10 && (generation = itemMeta.getGeneration()) != null) {
            booksNode.node(new Object[]{"generation"}).set((Object)generation.toString());
        }
        booksNode.node(new Object[]{"pages"}).set((Object)itemMeta.getPages());
    }

    @NotNull
    public BookItemBuilder generation(@Nullable BookMeta.Generation generation) {
        if (BukkitVersion.MAJOR >= 10) {
            ((BookMeta)this.itemMeta()).setGeneration(generation);
        }
        return this.self();
    }

    @NotNull
    public BookItemBuilder page(int page, @NotNull String text) {
        ((BookMeta)this.itemMeta()).setPage(page, text);
        return this.self();
    }

    @NotNull
    public BookItemBuilder pages(String ... list) {
        return this.pages(List.of(list));
    }

    @NotNull
    public BookItemBuilder pages(@NotNull List<String> list) {
        ((BookMeta)this.itemMeta()).setPages(list);
        return this.self();
    }

    @Override
    @NotNull
    public BookItemBuilder self() {
        return this;
    }

    @NotNull
    public BookItemBuilder title(@Nullable String title) {
        ((BookMeta)this.itemMeta()).setTitle(title);
        return this.self();
    }
}

