/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.platform.paper.hooks;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.infumialib.hooks.Hook;
import tr.com.infumia.infumialib.hooks.Wrapped;
import tr.com.infumia.infumialib.misc.Texts;
import tr.com.infumia.infumialib.platform.paper.files.PaperConfig;
import tr.com.infumia.infumialib.platform.paper.hooks.hooks.BentoBoxHook;
import tr.com.infumia.infumialib.platform.paper.hooks.hooks.BentoBoxWrapper;
import tr.com.infumia.infumialib.platform.paper.hooks.hooks.CitizensHook;
import tr.com.infumia.infumialib.platform.paper.hooks.hooks.CitizensWrapper;
import tr.com.infumia.infumialib.platform.paper.hooks.hooks.CombatLogXHook;
import tr.com.infumia.infumialib.platform.paper.hooks.hooks.CombatLogXWrapper;
import tr.com.infumia.infumialib.platform.paper.hooks.hooks.DeluxeCombatHook;
import tr.com.infumia.infumialib.platform.paper.hooks.hooks.DeluxeCombatWrapper;
import tr.com.infumia.infumialib.platform.paper.hooks.hooks.HolographicDisplaysHook;
import tr.com.infumia.infumialib.platform.paper.hooks.hooks.HolographicDisplaysWrapper;
import tr.com.infumia.infumialib.platform.paper.hooks.hooks.LuckPermsHook;
import tr.com.infumia.infumialib.platform.paper.hooks.hooks.LuckPermsWrapper;
import tr.com.infumia.infumialib.platform.paper.hooks.hooks.PlaceholderAPIWrapper;
import tr.com.infumia.infumialib.platform.paper.hooks.hooks.PlaceholderApiHook;
import tr.com.infumia.infumialib.platform.paper.hooks.hooks.VaultHook;
import tr.com.infumia.infumialib.platform.paper.hooks.hooks.VaultWrapper;
import tr.com.infumia.infumialib.platform.paper.hooks.hooks.WorldGuardHook;
import tr.com.infumia.infumialib.platform.paper.hooks.hooks.WorldGuardWrapper;

public final class Hooks {
    private static final Set<Hook<?>> DEFAULT_HOOKS = Set.of(new LuckPermsHook(), new PlaceholderApiHook(), new VaultHook(), new BentoBoxHook(), new CitizensHook(), new HolographicDisplaysHook(), new CombatLogXHook(), new DeluxeCombatHook(), new WorldGuardHook());
    private static final Map<String, Wrapped> WRAPPERS = new ConcurrentHashMap<String, Wrapped>();

    public static void addHook(@NotNull Hook<?> hook) {
        if (!hook.initiate()) {
            return;
        }
        String id = hook.id();
        WRAPPERS.put(id, (Wrapped)hook.get());
        Bukkit.getConsoleSender().sendMessage(Texts.replace(PaperConfig.instance().hookMessage(), Map.entry("hook", id)));
    }

    @NotNull
    public static Optional<BentoBoxWrapper> getBentoBox() {
        return Hooks.getWrapper("BentoBox");
    }

    @NotNull
    public static BentoBoxWrapper getBentoBoxOrThrow() {
        return Hooks.getBentoBox().orElseThrow();
    }

    @NotNull
    public static Optional<CitizensWrapper> getCitizens() {
        return Hooks.getWrapper("Citizens");
    }

    @NotNull
    public static CitizensWrapper getCitizensOrThrow() {
        return Hooks.getCitizens().orElseThrow();
    }

    @NotNull
    public static Optional<CombatLogXWrapper> getCombatLogX() {
        return Hooks.getWrapper("CombatLogX");
    }

    @NotNull
    public static CombatLogXWrapper getCombatLogXOrThrow() {
        return Hooks.getCombatLogX().orElseThrow();
    }

    @NotNull
    public static Optional<DeluxeCombatWrapper> getDeluxeCombat() {
        return Hooks.getWrapper("DeluxeCombat");
    }

    @NotNull
    public static DeluxeCombatWrapper getDeluxeCombatOrThrow() {
        return Hooks.getDeluxeCombat().orElseThrow();
    }

    @NotNull
    public static Optional<HolographicDisplaysWrapper> getHolographicDisplays() {
        return Hooks.getWrapper("HolographicDisplays");
    }

    @NotNull
    public static HolographicDisplaysWrapper getHolographicDisplaysOrThrow() {
        return Hooks.getHolographicDisplays().orElseThrow();
    }

    @NotNull
    public static Optional<LuckPermsWrapper> getLuckPerms() {
        return Hooks.getWrapper("LuckPerms");
    }

    @NotNull
    public static LuckPermsWrapper getLuckPermsOrThrow() {
        return Hooks.getLuckPerms().orElseThrow();
    }

    @NotNull
    public static Optional<PlaceholderAPIWrapper> getPlaceholderApi() {
        return Hooks.getWrapper("PlaceholderAPI");
    }

    @NotNull
    public static PlaceholderAPIWrapper getPlaceholderApiOrThrow() {
        return Hooks.getPlaceholderApi().orElseThrow();
    }

    @NotNull
    public static Optional<VaultWrapper> getVault() {
        return Hooks.getWrapper("Vault");
    }

    @NotNull
    public static VaultWrapper getVaultOrThrow() {
        return Hooks.getVault().orElseThrow();
    }

    @NotNull
    public static Optional<WorldGuardWrapper> getWorldGuard() {
        return Hooks.getWrapper("WorldGuard");
    }

    @NotNull
    public static WorldGuardWrapper getWorldGuardOrThrow() {
        return Hooks.getWorldGuard().orElseThrow();
    }

    public static void loadHooks() {
        DEFAULT_HOOKS.forEach(Hooks::addHook);
    }

    public static boolean supportsBentoBox() {
        return Hooks.getBentoBox().isPresent();
    }

    public static boolean supportsCitizens() {
        return Hooks.getCitizens().isPresent();
    }

    public static boolean supportsCombatLogX() {
        return Hooks.getCombatLogX().isPresent();
    }

    public static boolean supportsDeluxeCombat() {
        return Hooks.getDeluxeCombat().isPresent();
    }

    public static boolean supportsHolographicDisplays() {
        return Hooks.getHolographicDisplays().isPresent();
    }

    public static boolean supportsLuckPerms() {
        return Hooks.getLuckPerms().isPresent();
    }

    public static boolean supportsPlaceholderApi() {
        return Hooks.getPlaceholderApi().isPresent();
    }

    public static boolean supportsVault() {
        return Hooks.getVault().isPresent();
    }

    public static boolean supportsWorldGuard() {
        return Hooks.getWorldGuard().isPresent();
    }

    @NotNull
    private static <T extends Wrapped> Optional<T> getWrapper(@NotNull String wrappedId) {
        return Optional.ofNullable(WRAPPERS.get(wrappedId)).map(o -> o);
    }

    private Hooks() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

