/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.platform.paper.hooks;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.infumialib.platform.paper.hooks.Hooks;
import tr.com.infumia.infumialib.platform.paper.utils.Numbers;

public final class Groups {
    public static void calculatePermissionLimit(@NotNull String permission, @NotNull List<String> permissions, @NotNull AtomicLong calculatedLimit) {
        for (String perm : permissions) {
            int limit;
            String substring;
            if (perm.startsWith("-") || !perm.startsWith(permission) || !Numbers.isLong(substring = perm.substring(perm.lastIndexOf(".") + 1)) || (long)(limit = Integer.parseInt(substring)) <= calculatedLimit.get()) continue;
            calculatedLimit.set(limit);
        }
    }

    public static boolean containsGroup(@NotNull String group, @NotNull Player player) {
        if (Hooks.supportsLuckPerms()) {
            return Hooks.getLuckPermsOrThrow().getGroups(player).orElse("").equalsIgnoreCase(group);
        }
        return false;
    }

    public static long getEffectiveLimitedPermission(@NotNull String permission, @NotNull Player player, long defaultValue) {
        if (Hooks.supportsLuckPerms()) {
            return Hooks.getLuckPermsOrThrow().getEffectiveLimitedPermission(permission, player, defaultValue);
        }
        AtomicLong calculatedLimit = new AtomicLong(defaultValue);
        List<String> permissions = player.getEffectivePermissions().stream().filter(PermissionAttachmentInfo::getValue).map(PermissionAttachmentInfo::getPermission).collect(Collectors.toList());
        Groups.calculatePermissionLimit(permission, permissions, calculatedLimit);
        return calculatedLimit.get();
    }

    @NotNull
    public static Optional<String> getFirstGroup(@NotNull Player player) {
        if (Hooks.supportsLuckPerms()) {
            return Hooks.getLuckPermsOrThrow().getGroups(player);
        }
        return Optional.empty();
    }

    private Groups() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

