/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.platform.paper.files;

import java.nio.file.Path;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.configurate.CommentedConfigurationNode;
import org.spongepowered.configurate.ConfigurateException;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.hocon.HoconConfigurationLoader;
import org.spongepowered.configurate.objectmapping.ConfigSerializable;
import org.spongepowered.configurate.objectmapping.meta.Comment;
import org.spongepowered.configurate.objectmapping.meta.Setting;
import tr.com.infumia.infumialib.configurate.InfumiaCollection;
import tr.com.infumia.infumialib.platform.paper.configurate.PaperCollection;

@ConfigSerializable
public final class PaperConfig {
    @NotNull
    private static PaperConfig INSTANCE = new PaperConfig();
    @Setting
    @Comment(value="Hooking message for each plugin/library.")
    private String hookMessage = "{#F0E68C}%hook% {#AFEEEE}is hooking.";
    @Setting
    @Comment(value="Whether enable multiple server support or not.")
    private boolean multiServer = false;
    @Setting
    @Comment(value="Redis sentinel password.")
    private String redisPassword = "password";
    @Setting
    @Comment(value="Server's group.")
    private String serverGroup = "lobby";
    @Setting
    @Comment(value="Server's name.")
    private String serverName = UUID.randomUUID().toString();

    public static void init(@NotNull Path directory) throws ConfigurateException {
        HoconConfigurationLoader loader = ((HoconConfigurationLoader.Builder)((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().path(directory.resolve("paper.conf"))).defaultOptions(options -> options.serializers(builder -> builder.registerAll(InfumiaCollection.COLLECTION).registerAll(PaperCollection.COLLECTION)))).build();
        CommentedConfigurationNode node = (CommentedConfigurationNode)loader.load();
        PaperConfig config = (PaperConfig)node.get(PaperConfig.class, (Object)new PaperConfig());
        node.set(PaperConfig.class, (Object)config);
        loader.save((ConfigurationNode)node);
        INSTANCE = config;
    }

    @NotNull
    public static PaperConfig instance() {
        return INSTANCE;
    }

    public String hookMessage() {
        return this.hookMessage;
    }

    public boolean multiServer() {
        return this.multiServer;
    }

    public String redisPassword() {
        return this.redisPassword;
    }

    public String serverGroup() {
        return this.serverGroup;
    }

    public String serverName() {
        return this.serverName;
    }

    public PaperConfig hookMessage(String hookMessage) {
        this.hookMessage = hookMessage;
        return this;
    }

    public PaperConfig multiServer(boolean multiServer) {
        this.multiServer = multiServer;
        return this;
    }

    public PaperConfig redisPassword(String redisPassword) {
        this.redisPassword = redisPassword;
        return this;
    }

    public PaperConfig serverGroup(String serverGroup) {
        this.serverGroup = serverGroup;
        return this;
    }

    public PaperConfig serverName(String serverName) {
        this.serverName = serverName;
        return this;
    }
}

