/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.platform.paper.worldborderapi;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tr.com.infumia.infumialib.platform.paper.worldborderapi.Border;
import tr.com.infumia.infumialib.platform.paper.worldborderapi.BorderData;
import tr.com.infumia.infumialib.platform.paper.worldborderapi.BorderDataTagType;
import tr.com.infumia.infumialib.platform.paper.worldborderapi.EarthBorder;
import tr.com.infumia.infumialib.platform.paper.worldborderapi.PersistentBorder;
import tr.com.infumia.infumialib.platform.paper.worldborderapi.Position;

public final class PersistenceWrapper
implements PersistentBorder {
    @NotNull
    private final Border border;
    @NotNull
    private final BorderDataTagType borderDataTagType;
    @NotNull
    private final NamespacedKey worldBorderDataKey;

    public PersistenceWrapper(@NotNull Plugin plugin, @NotNull Border border) {
        this.border = border;
        this.worldBorderDataKey = new NamespacedKey(plugin, "world_border_data");
        this.borderDataTagType = new BorderDataTagType(plugin);
    }

    private static void applyWorldDataToBorder(@NotNull EarthBorder border, @NotNull BorderData data) {
        data.applyCenter((x, z) -> border.center(new Position((double)x, (double)z)));
        border.size(data.size());
        border.damageBufferInBlocks(data.damageBufferInBlocks());
        border.warningDistanceInBlocks(data.warningDistance());
        border.warningTimeInSeconds(data.warningTimeSeconds());
    }

    @Override
    @NotNull
    public EarthBorder get(@NotNull Player player) {
        EarthBorder border = this.border.get(player);
        PersistentDataContainer container = player.getPersistentDataContainer();
        if (container.has(this.worldBorderDataKey, (PersistentDataType)this.borderDataTagType)) {
            PersistenceWrapper.applyWorldDataToBorder(border, Objects.requireNonNull((BorderData)container.get(this.worldBorderDataKey, (PersistentDataType)this.borderDataTagType)));
        }
        return border;
    }

    @Override
    @NotNull
    public EarthBorder get(@NotNull World world) {
        return this.border.get(world);
    }

    @Override
    public void resetWorldBorderToGlobal(@NotNull Player player) {
        this.border.resetWorldBorderToGlobal(player);
        PersistentDataContainer container = player.getPersistentDataContainer();
        if (container.has(this.worldBorderDataKey, (PersistentDataType)this.borderDataTagType)) {
            container.remove(this.worldBorderDataKey);
        }
    }

    @Override
    public void sendRedScreenForSeconds(@NotNull Player player, long timeSeconds, @NotNull Plugin plugin) {
        this.border.sendRedScreenForSeconds(player, timeSeconds, plugin);
    }

    @Override
    public void set(@NotNull Player player, double size) {
        this.border.set(player, size);
        this.modifyAndUpdateWorldData(player, data -> data.size(size));
    }

    @Override
    public void set(@NotNull Player player, double size, @NotNull Vector vector) {
        this.set(player, size, Position.of(vector));
    }

    @Override
    public void set(@NotNull Player player, double size, @NotNull Location location) {
        this.set(player, size, Position.of(location));
    }

    @Override
    public void set(@NotNull Player player, double size, @NotNull Position position) {
        this.border.set(player, size, position);
        this.modifyAndUpdateWorldData(player, data -> {
            data.size(size);
            data.center(position.x(), position.z());
        });
    }

    @Override
    public void set(@NotNull Player player, double size, long milliSeconds) {
        this.border.set(player, size, milliSeconds);
        this.modifyAndUpdateWorldData(player, data -> data.size(size));
    }

    @Override
    public void set(@NotNull Player player, double size, long time, @NotNull TimeUnit timeUnit) {
        this.border.set(player, size, time, timeUnit);
        this.modifyAndUpdateWorldData(player, data -> data.size(size));
    }

    @Override
    @Nullable
    public BorderData worldBorderData(@NotNull Player player) {
        if (player.getPersistentDataContainer().has(this.worldBorderDataKey, (PersistentDataType)this.borderDataTagType)) {
            return (BorderData)player.getPersistentDataContainer().get(this.worldBorderDataKey, (PersistentDataType)this.borderDataTagType);
        }
        return null;
    }

    private void modifyAndUpdateWorldData(@NotNull Player player, @NotNull Consumer<BorderData> consumer) {
        PersistentDataContainer container = player.getPersistentDataContainer();
        BorderData data = container.has(this.worldBorderDataKey, (PersistentDataType)this.borderDataTagType) ? Objects.requireNonNull((BorderData)container.get(this.worldBorderDataKey, (PersistentDataType)this.borderDataTagType)) : new BorderData();
        consumer.accept(data);
        container.set(this.worldBorderDataKey, (PersistentDataType)this.borderDataTagType, (Object)data);
    }
}

