/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.misc;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Texts {
    @Nullable
    @Contract(value="null -> null; !null -> !null")
    public static String endOfLine(@Nullable String text) {
        return Optional.ofNullable(text).map(s -> s.replace("\\n", "\n")).orElse(null);
    }

    @SafeVarargs
    @Nullable
    @Contract(value="null, _ -> null; !null, _ -> !null")
    public static String replace(@Nullable String text, Map.Entry<String, Object> ... entries) {
        return Texts.replace(text, Set.of(entries));
    }

    @Nullable
    @Contract(value="null, _ -> null; !null, _ -> !null")
    public static String replace(@Nullable String text, @NotNull Collection<Map.Entry<String, Object>> entries) {
        return Optional.ofNullable(text).map(s -> {
            AtomicReference<String> replaced = new AtomicReference<String>((String)s);
            entries.stream().map(entry -> ((String)entry.getKey()).startsWith("%") ? entry : Map.entry("%" + (String)entry.getKey() + "%", entry.getValue())).forEach(entry -> replaced.set(((String)replaced.get()).replace((CharSequence)entry.getKey(), entry.getValue().toString())));
            return replaced.get();
        }).orElse(null);
    }
}

