/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.reflection.field;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tr.com.infumia.infumialib.reflection.RefField;
import tr.com.infumia.infumialib.reflection.RefFieldExecuted;

public final class FieldOf
implements RefField {
    private static final Logger log = Logger.getLogger(FieldOf.class.getName());
    @NotNull
    private final Field field;

    @Override
    @NotNull
    public <A extends Annotation> Optional<A> getAnnotation(@NotNull Class<A> annotationClass) {
        return Optional.ofNullable(this.field.getDeclaredAnnotation(annotationClass));
    }

    @Override
    @NotNull
    public <A extends Annotation> Collection<A> getAnnotations(@NotNull Class<A> annotationClass) {
        return List.of(this.field.getDeclaredAnnotationsByType(annotationClass));
    }

    @Override
    @NotNull
    public String getName() {
        return this.field.getName();
    }

    @Override
    @NotNull
    public Field getRealField() {
        return this.field;
    }

    @Override
    @NotNull
    public Class<?> getType() {
        return this.field.getType();
    }

    @Override
    @NotNull
    public RefFieldExecuted of(@Nullable Object object) {
        return new FieldExecuted(object);
    }

    @Override
    public boolean hasFinal() {
        return Modifier.isFinal(this.field.getModifiers());
    }

    @Override
    public boolean hasPrivate() {
        return Modifier.isPrivate(this.field.getModifiers());
    }

    @Override
    public boolean hasPublic() {
        return Modifier.isPublic(this.field.getModifiers());
    }

    @Override
    public boolean hasStatic() {
        return Modifier.isStatic(this.field.getModifiers());
    }

    public FieldOf(@NotNull Field field) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        this.field = field;
    }

    private final class FieldExecuted
    implements RefFieldExecuted {
        @Nullable
        private final Object object;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public Optional<Object> getValue() {
            boolean accessible = FieldOf.this.field.isAccessible();
            try {
                FieldOf.this.field.setAccessible(true);
                Optional<Object> optional = Optional.ofNullable(FieldOf.this.field.get(this.object));
                return optional;
            }
            catch (IllegalAccessException exception) {
                log.log(Level.SEVERE, "FieldExecuted#getValue()", exception);
                Optional<Object> optional = Optional.empty();
                return optional;
            }
            finally {
                FieldOf.this.field.setAccessible(accessible);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setValue(@Nullable Object value) {
            boolean accessible = FieldOf.this.field.isAccessible();
            try {
                FieldOf.this.field.setAccessible(true);
                FieldOf.this.field.set(this.object, value);
            }
            catch (IllegalAccessException exception) {
                log.log(Level.SEVERE, "FieldExecuted#setValue(Object)", exception);
            }
            finally {
                FieldOf.this.field.setAccessible(accessible);
            }
        }

        public FieldExecuted(Object object) {
            this.object = object;
        }
    }
}

