/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.platform.paper.bukkititembuilder;

import com.cryptomorin.xseries.SkullUtils;
import com.cryptomorin.xseries.XEnchantment;
import com.cryptomorin.xseries.XMaterial;
import com.google.common.collect.Multimap;
import io.github.bananapuncher714.nbteditor.NBTEditor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.material.MaterialData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tr.com.infumia.infumialib.platform.paper.bukkititembuilder.Buildable;
import tr.com.infumia.infumialib.platform.paper.bukkititembuilder.ItemStackBuilder;
import tr.com.infumia.infumialib.platform.paper.bukkititembuilder.util.ItemStackUtil;
import tr.com.infumia.infumialib.platform.paper.color.XColor;
import tr.com.infumia.infumialib.platform.paper.version.BukkitVersion;
import tr.com.infumia.infumialib.transformer.TransformedData;

public abstract class Builder<X extends Builder<X, T>, T extends ItemMeta>
implements Buildable<X, T> {
    public static final int VERSION = new BukkitVersion().getMinor();
    private static final ItemStackDeserializer ITEM_STACK_DESERIALIZER = new ItemStackDeserializer();
    private static final SimpleItemStackDeserializer SIMPLE_ITEM_STACK_DESERIALIZER = new SimpleItemStackDeserializer();
    @NotNull
    private final T itemMeta;
    @NotNull
    private ItemStack itemStack;

    @NotNull
    public static <X extends Builder<X, ?>> ItemMetaDeserializer<X> getItemMetaDeserializer(@NotNull X builder) {
        return new ItemMetaDeserializer<X>(builder);
    }

    @NotNull
    public static ItemStackDeserializer getItemStackDeserializer() {
        return ITEM_STACK_DESERIALIZER;
    }

    @NotNull
    public static SimpleItemStackDeserializer getSimpleItemStackDeserializer() {
        return SIMPLE_ITEM_STACK_DESERIALIZER;
    }

    @NotNull
    public final X addAttributeModifier(@NotNull Attribute attribute, @NotNull AttributeModifier modifier) {
        if (VERSION >= 14) {
            this.itemMeta.addAttributeModifier(attribute, modifier);
        }
        return (X)((Builder)this.getSelf());
    }

    @NotNull
    public final X addAttributeModifier(@NotNull Multimap<Attribute, AttributeModifier> map) {
        if (VERSION >= 14) {
            this.itemMeta.setAttributeModifiers(map);
        }
        return (X)((Builder)this.getSelf());
    }

    @NotNull
    public final X addCustomData(@NotNull Object value, Object ... keys) {
        NBTEditor.NBTCompound compound = NBTEditor.getNBTCompound((Object)this.itemStack, (Object[])new Object[0]);
        compound.set(value, new Object[]{"tag", keys});
        return (X)this.setItemStack(NBTEditor.getItemFromTag((NBTEditor.NBTCompound)compound));
    }

    @NotNull
    public final X addEnchantments(String ... enchantments) {
        for (String enchantmentString : enchantments) {
            String enchantment;
            String[] split = enchantmentString.split(":");
            AtomicInteger level = new AtomicInteger();
            if (split.length == 1) {
                enchantment = split[0];
                level.set(1);
            } else {
                enchantment = split[0];
                try {
                    level.set(Integer.parseInt(split[1]));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            XEnchantment.matchXEnchantment((String)enchantment).ifPresent(xEnchantment -> this.addEnchantments((XEnchantment)xEnchantment, level.get()));
        }
        return (X)((Builder)this.getSelf());
    }

    @NotNull
    public final X addEnchantments(@NotNull XEnchantment enchantment, int level) {
        return (X)Optional.ofNullable(enchantment.parseEnchantment()).map(value -> this.addEnchantments((Enchantment)value, level)).orElse((Builder)this.getSelf());
    }

    @NotNull
    public final X addEnchantments(@NotNull Enchantment enchantment, int level) {
        return this.addEnchantments(Map.of(enchantment, level));
    }

    @NotNull
    public final X addEnchantments(@NotNull Map<Enchantment, Integer> enchantments) {
        enchantments.forEach((enchantment, level) -> this.itemMeta.addEnchant(enchantment, level.intValue(), true));
        return (X)((Builder)this.getSelf());
    }

    @NotNull
    public final X addFlag(ItemFlag ... flags) {
        this.itemMeta.addItemFlags(flags);
        return (X)((Builder)this.getSelf());
    }

    @NotNull
    public final X addFlags(@NotNull Collection<String> flags) {
        for (String flag : flags) {
            this.addFlag(ItemFlag.valueOf((String)flag));
        }
        return (X)((Builder)this.getSelf());
    }

    @NotNull
    public final X addGlowEffect(@NotNull Enchantment enchantment, int level) {
        this.addFlag(ItemFlag.HIDE_ENCHANTS);
        return this.addEnchantments(enchantment, level);
    }

    @NotNull
    public final X addGlowEffect(@NotNull Enchantment enchantment) {
        return this.addGlowEffect(enchantment, 1);
    }

    @NotNull
    public final X addGlowEffect() {
        return (X)Optional.ofNullable(XMaterial.BOW.parseMaterial()).map(material -> this.addGlowEffect(this.itemStack.getType() != material ? Enchantment.ARROW_INFINITE : Enchantment.LUCK)).orElse((Builder)this.getSelf());
    }

    @NotNull
    public final X addLore(String ... lore) {
        return this.addLore(true, lore);
    }

    @NotNull
    public final X addLore(boolean colored, String ... lore) {
        return this.addLore(List.of(lore), colored);
    }

    @NotNull
    public final X addLore(@NotNull List<String> lore) {
        return this.addLore(lore, true);
    }

    @NotNull
    public final X addLore(@NotNull List<String> lore, boolean colored) {
        List join = Optional.ofNullable(this.itemMeta.getLore()).orElse(new ArrayList());
        join.addAll(colored ? XColor.colorize(lore) : lore);
        this.itemMeta.setLore(join);
        return (X)((Builder)this.getSelf());
    }

    @NotNull
    public final X addLoreAsComponent(Component ... lore) {
        return this.addLoreAsComponent(List.of(lore));
    }

    @NotNull
    public final X addLoreAsComponent(@NotNull List<Component> lore) {
        List join = Optional.ofNullable(this.itemMeta.lore()).orElse(new ArrayList());
        join.addAll(lore);
        this.itemMeta.lore(join);
        return (X)((Builder)this.getSelf());
    }

    @NotNull
    public final X addSerializedEnchantments(@NotNull Map<String, Integer> enchantments) {
        enchantments.forEach((enchantmentString, level) -> XEnchantment.matchXEnchantment((String)String.valueOf(enchantmentString)).flatMap(enchant -> Optional.ofNullable(enchant.parseEnchantment())).ifPresent(enchantment -> this.addEnchantments((Enchantment)enchantment, (int)level)));
        return (X)((Builder)this.getSelf());
    }

    @NotNull
    public final X removeAttributeModifier(@NotNull Attribute attribute) {
        if (VERSION >= 14) {
            this.itemMeta.removeAttributeModifier(attribute);
        }
        return (X)((Builder)this.getSelf());
    }

    @NotNull
    public final X removeAttributeModifier(@NotNull EquipmentSlot slot) {
        if (VERSION >= 14) {
            this.itemMeta.removeAttributeModifier(slot);
        }
        return (X)((Builder)this.getSelf());
    }

    @NotNull
    public final X removeAttributeModifier(@NotNull Attribute attribute, @NotNull AttributeModifier modifier) {
        if (VERSION >= 14) {
            this.itemMeta.removeAttributeModifier(attribute, modifier);
        }
        return (X)((Builder)this.getSelf());
    }

    @NotNull
    public final X removeFlag(ItemFlag ... flags) {
        this.itemMeta.removeItemFlags(flags);
        return (X)((Builder)this.getSelf());
    }

    @NotNull
    public final X setAmount(int amount) {
        this.itemStack.setAmount(amount);
        return (X)((Builder)this.getSelf());
    }

    @NotNull
    public final X setCustomModelData(@Nullable Integer data) {
        if (VERSION >= 14) {
            this.itemMeta.setCustomModelData(data);
        }
        return (X)((Builder)this.getSelf());
    }

    @NotNull
    public final X setData(byte data) {
        return this.setData(this.itemStack.getType().getNewData(data));
    }

    @NotNull
    public final X setData(@NotNull MaterialData data) {
        this.itemStack.setData(data);
        return (X)((Builder)this.getSelf());
    }

    @NotNull
    public final X setDurability(short durability) {
        this.itemStack.setDurability(durability);
        return (X)((Builder)this.getSelf());
    }

    @Override
    @NotNull
    public final X setItemStack(@NotNull ItemStack itemStack) {
        this.itemStack = itemStack;
        return (X)((Builder)this.getSelf());
    }

    @Override
    @NotNull
    public final ItemStack getItemStack(boolean update) {
        if (update && !Objects.equals(this.itemMeta, this.itemStack.getItemMeta())) {
            this.itemStack.setItemMeta(this.itemMeta);
        }
        return this.itemStack;
    }

    @NotNull
    public final X setLocalizedName(@Nullable String name) {
        if (VERSION >= 12) {
            this.itemMeta.setLocalizedName(name);
        }
        return (X)((Builder)this.getSelf());
    }

    @NotNull
    public final X setLore(String ... lore) {
        return this.setLore(true, lore);
    }

    @NotNull
    public final X setLore(boolean colored, String ... lore) {
        return this.setLore(List.of(lore), colored);
    }

    @NotNull
    public final X setLore(@NotNull List<String> lore) {
        return this.setLore(lore, true);
    }

    @NotNull
    public final X setLore(@NotNull List<String> lore, boolean colored) {
        this.itemMeta.setLore(colored ? XColor.colorize(lore) : lore);
        return (X)((Builder)this.getSelf());
    }

    @NotNull
    public final X setLoreAsComponent(Component ... lore) {
        return this.setLoreAsComponent(List.of(lore));
    }

    @NotNull
    public final X setLoreAsComponent(@NotNull List<Component> lore) {
        this.itemMeta.lore(lore);
        return (X)((Builder)this.getSelf());
    }

    @NotNull
    public final X setMaterial(@NotNull Material material) {
        this.itemStack.setType(material);
        return (X)((Builder)this.getSelf());
    }

    @NotNull
    public final X setName(@NotNull String name) {
        return this.setName(name, true);
    }

    @NotNull
    public final X setName(@NotNull String name, boolean colored) {
        this.itemMeta.setDisplayName(colored ? XColor.colorize(name) : name);
        return (X)((Builder)this.getSelf());
    }

    @NotNull
    public final X setNameAsComponent(@NotNull Component name) {
        this.itemMeta.displayName(name);
        return (X)((Builder)this.getSelf());
    }

    @NotNull
    public final X setType(@NotNull Material material) {
        this.itemStack.setType(material);
        return (X)((Builder)this.getSelf());
    }

    @NotNull
    public final X setUnbreakable(boolean unbreakable) {
        if (VERSION < 11) {
            return (X)this.setItemStack((ItemStack)NBTEditor.set((Object)this.itemStack, (Object)(unbreakable ? (byte)1 : 0), (Object[])new Object[]{"Unbreakable"}));
        }
        this.itemMeta.setUnbreakable(unbreakable);
        return (X)((Builder)this.getSelf());
    }

    @NotNull
    public final X setVersion(int version) {
        if (VERSION >= 14) {
            this.itemMeta.setVersion(version);
        }
        return (X)((Builder)this.getSelf());
    }

    protected Builder(@NotNull T itemMeta, @NotNull ItemStack itemStack) {
        if (itemMeta == null) {
            throw new NullPointerException("itemMeta is marked non-null but is null");
        }
        if (itemStack == null) {
            throw new NullPointerException("itemStack is marked non-null but is null");
        }
        this.itemMeta = itemMeta;
        this.itemStack = itemStack;
    }

    @Override
    @NotNull
    public T getItemMeta() {
        return this.itemMeta;
    }

    public static final class ItemMetaDeserializer<B extends Builder<?, ?>>
    implements Function<TransformedData, B> {
        @NotNull
        private final B builder;

        @Override
        @NotNull
        public B apply(@NotNull TransformedData data) {
            ItemStack itemStack = ((Builder)this.builder).getItemStack(false);
            ItemMeta itemMeta = itemStack.getItemMeta();
            if (itemMeta == null) {
                return this.builder;
            }
            if (itemMeta instanceof SkullMeta) {
                data.get("skull", String.class).ifPresent(s -> SkullUtils.applySkin((ItemMeta)itemMeta, (String)s));
            }
            MiniMessage miniMessage = MiniMessage.miniMessage();
            data.get("name", String.class).ifPresent(name -> {
                if (XColor.isKyoriEnabled()) {
                    try {
                        ((Builder)this.builder).setNameAsComponent(miniMessage.deserialize(name));
                    }
                    catch (Exception e) {
                        ((Builder)this.builder).setName(XColor.colorize(name));
                    }
                } else {
                    ((Builder)this.builder).setName(XColor.colorize(name));
                }
            });
            data.getAsCollection("lore", String.class).ifPresent(lore -> {
                if (XColor.isKyoriEnabled()) {
                    try {
                        ArrayList<Component> list = new ArrayList<Component>();
                        for (String s : lore) {
                            list.add(miniMessage.deserialize((Object)s));
                        }
                        ((Builder)this.builder).setLoreAsComponent(list);
                    }
                    catch (Exception e) {
                        ((Builder)this.builder).setLore(XColor.colorize(lore));
                    }
                } else {
                    ((Builder)this.builder).setLore(XColor.colorize(lore));
                }
            });
            data.getAsMap("enchants", String.class, Integer.class).ifPresent(arg_0 -> this.builder.addSerializedEnchantments(arg_0));
            data.getAsCollection("flags", String.class).ifPresent(arg_0 -> this.builder.addFlags(arg_0));
            if (VERSION >= 14) {
                data.get("custom-model-data", Integer.TYPE).ifPresent(arg_0 -> this.builder.setCustomModelData(arg_0));
            }
            itemStack.setItemMeta(itemMeta);
            return this.builder;
        }

        private ItemMetaDeserializer(@NotNull B builder) {
            if (builder == null) {
                throw new NullPointerException("builder is marked non-null but is null");
            }
            this.builder = builder;
        }
    }

    public static final class ItemStackDeserializer
    implements Function<TransformedData, Optional<ItemStack>> {
        @Override
        @NotNull
        public Optional<ItemStack> apply(@NotNull TransformedData data) {
            ItemStack itemStack;
            Optional materialOptional = data.get("material", String.class).flatMap(ItemStackUtil::parseMaterial);
            if (materialOptional.isEmpty()) {
                return Optional.empty();
            }
            Material material = (Material)materialOptional.get();
            int amount = data.get("amount", Integer.TYPE).orElse(1);
            if (VERSION < 13) {
                itemStack = new ItemStack(material, amount);
                data.get("damage", Short.TYPE).ifPresent(arg_0 -> ((ItemStack)itemStack).setDurability(arg_0));
                data.get("data", Byte.TYPE).map(arg_0 -> ((Material)material).getNewData(arg_0)).ifPresent(arg_0 -> ((ItemStack)itemStack).setData(arg_0));
            } else {
                itemStack = new ItemStack(material, amount);
                data.get("damage", Short.TYPE).ifPresent(arg_0 -> ((ItemStack)itemStack).setDurability(arg_0));
            }
            return Optional.of(itemStack);
        }
    }

    public static final class SimpleItemStackDeserializer
    implements Function<TransformedData, Optional<ItemStackBuilder>> {
        @Override
        @NotNull
        public Optional<ItemStackBuilder> apply(@NotNull TransformedData data) {
            Optional materialOptional = data.get("material", String.class).flatMap(ItemStackUtil::parseMaterial);
            if (materialOptional.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(ItemStackBuilder.from((Material)materialOptional.get()));
        }
    }
}

