/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.transformer.declarations;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tr.com.infumia.infumialib.reflection.RefField;

public final class GenericDeclaration {
    private static final Map<String, Class<?>> NAME_TO_PRIMITIVE = Map.of(Boolean.TYPE.getName(), Boolean.TYPE, Byte.TYPE.getName(), Byte.TYPE, Character.TYPE.getName(), Character.TYPE, Double.TYPE.getName(), Double.TYPE, Float.TYPE.getName(), Float.TYPE, Integer.TYPE.getName(), Integer.TYPE, Long.TYPE.getName(), Long.TYPE, Short.TYPE.getName(), Short.TYPE);
    private static final Map<Class<?>, Class<?>> PRIMITIVE_TO_WRAPPER = Map.of(Boolean.TYPE, Boolean.class, Byte.TYPE, Byte.class, Character.TYPE, Character.class, Double.TYPE, Double.class, Float.TYPE, Float.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, Short.TYPE, Short.class);
    private static final Collection<Class<?>> PRIMITIVE_WRAPPERS = Set.of(Boolean.class, Byte.class, Character.class, Double.class, Float.class, Integer.class, Long.class, Short.class);
    private final boolean isEnum;
    private final boolean isPrimitive;
    @NotNull
    private final List<GenericDeclaration> subTypes;
    @Nullable
    private final Class<?> type;

    private GenericDeclaration(boolean isEnum, boolean isPrimitive, @NotNull List<GenericDeclaration> subTypes, @Nullable Class<?> type) {
        this.isEnum = isEnum;
        this.isPrimitive = isPrimitive;
        this.subTypes = GenericDeclaration.convertSimple(subTypes);
        this.type = GenericDeclaration.convertSimple(type);
    }

    private GenericDeclaration(@NotNull List<GenericDeclaration> subTypes, @Nullable Class<?> type) {
        this(type != null && type.isEnum(), type != null && type.isPrimitive(), subTypes, type);
    }

    private GenericDeclaration(@Nullable Class<?> type) {
        this(Collections.emptyList(), type);
    }

    public static boolean isWrapper(@NotNull Class<?> primitive, @NotNull Class<?> wrapper) {
        return Objects.equals(PRIMITIVE_TO_WRAPPER.get(primitive), wrapper);
    }

    public static boolean isWrapperBoth(@NotNull Class<?> left, @NotNull Class<?> right) {
        return GenericDeclaration.isWrapper(left, right) || GenericDeclaration.isWrapper(right, left);
    }

    @NotNull
    public static GenericDeclaration of(@Nullable Class<?> type, @NotNull List<Class<?>> subTypes) {
        ArrayList<GenericDeclaration> list = new ArrayList<GenericDeclaration>();
        for (Class<?> subType : subTypes) {
            list.add(GenericDeclaration.ofReady(subType));
        }
        return GenericDeclaration.ofReady(type, list);
    }

    @NotNull
    public static GenericDeclaration of(@Nullable Class<?> type, Class<?> ... subTypes) {
        ArrayList<GenericDeclaration> list = new ArrayList<GenericDeclaration>();
        for (Class<?> subType : subTypes) {
            list.add(GenericDeclaration.ofReady(subType));
        }
        return GenericDeclaration.ofReady(type, list);
    }

    @NotNull
    public static GenericDeclaration of(@Nullable Class<?> type, GenericDeclaration ... subTypes) {
        return GenericDeclaration.ofReady(type, List.of(subTypes));
    }

    @NotNull
    public static GenericDeclaration of(@NotNull Field field) {
        return GenericDeclaration.of(field.getGenericType());
    }

    @NotNull
    public static GenericDeclaration of(@NotNull RefField field) {
        return GenericDeclaration.of(field.getRealField());
    }

    @NotNull
    public static GenericDeclaration of(@NotNull Type type) {
        return GenericDeclaration.from(type.getTypeName());
    }

    @NotNull
    public static GenericDeclaration of(@NotNull Object object) {
        if (object instanceof Class) {
            return GenericDeclaration.of((Class)object);
        }
        return GenericDeclaration.of(object.getClass());
    }

    @NotNull
    public static GenericDeclaration ofReady(@Nullable Class<?> type) {
        return new GenericDeclaration(type);
    }

    @NotNull
    public static GenericDeclaration ofReady(@Nullable Class<?> type, @NotNull List<GenericDeclaration> subTypes) {
        return new GenericDeclaration(subTypes, type);
    }

    @NotNull
    public static Object toPrimitive(@NotNull Object object) {
        if (object instanceof Boolean) {
            return (boolean)((Boolean)object);
        }
        if (object instanceof Byte) {
            return (byte)((Byte)object);
        }
        if (object instanceof Character) {
            return Character.valueOf(((Character)object).charValue());
        }
        if (object instanceof Double) {
            return (double)((Double)object);
        }
        if (object instanceof Float) {
            return Float.valueOf(((Float)object).floatValue());
        }
        if (object instanceof Integer) {
            return (int)((Integer)object);
        }
        if (object instanceof Long) {
            return (long)((Long)object);
        }
        if (object instanceof Short) {
            return (short)((Short)object);
        }
        return object;
    }

    @NotNull
    private static List<GenericDeclaration> convertSimple(@NotNull List<GenericDeclaration> declarations) {
        ArrayList<GenericDeclaration> list = new ArrayList<GenericDeclaration>();
        for (GenericDeclaration declaration : declarations) {
            list.add(new GenericDeclaration(declaration.isEnum(), declaration.isPrimitive(), GenericDeclaration.convertSimple(declaration.getSubTypes()), GenericDeclaration.convertSimple(declaration.getType())));
        }
        return list;
    }

    @Nullable
    @Contract(value="null -> null; !null -> !null")
    private static Class<?> convertSimple(@Nullable Class<?> cls) {
        if (cls == null) {
            return null;
        }
        if (List.class.isAssignableFrom(cls)) {
            return List.class;
        }
        if (Map.class.isAssignableFrom(cls)) {
            return Map.class;
        }
        return cls;
    }

    @NotNull
    private static GenericDeclaration from(@NotNull String typeName) {
        StringBuilder builder = new StringBuilder();
        char[] chars = typeName.toCharArray();
        for (int index = 0; index < chars.length; ++index) {
            char ch = chars[index];
            if (ch == '<') {
                String className = builder.toString();
                Class<?> type = GenericDeclaration.getPrimitiveOrClass(className);
                String genericType = typeName.substring(index + 1, typeName.length() - 1);
                ArrayList<GenericDeclaration> subTypes = new ArrayList<GenericDeclaration>();
                for (String s : GenericDeclaration.getSeparateTypes(genericType)) {
                    subTypes.add(GenericDeclaration.from(s));
                }
                return GenericDeclaration.ofReady(type, subTypes);
            }
            builder.append(ch);
        }
        return GenericDeclaration.ofReady(GenericDeclaration.getPrimitiveOrClass(builder.toString()));
    }

    @Nullable
    private static Class<?> getPrimitiveOrClass(@NotNull String type) {
        if (NAME_TO_PRIMITIVE.containsKey(type)) {
            return NAME_TO_PRIMITIVE.get(type);
        }
        try {
            return Class.forName(type);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    @NotNull
    private static List<String> getSeparateTypes(@NotNull String types) {
        StringBuilder builder = new StringBuilder();
        char[] charArray = types.toCharArray();
        boolean skip = false;
        ArrayList<String> out = new ArrayList<String>();
        for (int index = 0; index < charArray.length; ++index) {
            char c = charArray[index];
            if (c == '<') {
                skip = true;
            }
            if (c == '>') {
                skip = false;
            }
            if (skip) {
                builder.append(c);
                continue;
            }
            if (c == ',') {
                out.add(builder.toString());
                builder.setLength(0);
                ++index;
                continue;
            }
            builder.append(c);
        }
        out.add(builder.toString());
        return out;
    }

    @NotNull
    public Optional<GenericDeclaration> getSubTypeAt(int index) {
        return index >= this.subTypes.size() ? Optional.empty() : Optional.ofNullable(this.subTypes.get(index));
    }

    public boolean hasWrapper() {
        return this.type != null && PRIMITIVE_WRAPPERS.contains(this.type);
    }

    @NotNull
    public Optional<Class<?>> toWrapper() {
        return this.type != null ? Optional.ofNullable(PRIMITIVE_TO_WRAPPER.get(this.type)) : Optional.empty();
    }

    public boolean isEnum() {
        return this.isEnum;
    }

    public boolean isPrimitive() {
        return this.isPrimitive;
    }

    @NotNull
    public List<GenericDeclaration> getSubTypes() {
        return this.subTypes;
    }

    @Nullable
    public Class<?> getType() {
        return this.type;
    }

    public String toString() {
        return "GenericDeclaration(isEnum=" + this.isEnum() + ", isPrimitive=" + this.isPrimitive() + ", subTypes=" + this.getSubTypes() + ", type=" + this.getType() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GenericDeclaration)) {
            return false;
        }
        GenericDeclaration other = (GenericDeclaration)o;
        if (this.isEnum() != other.isEnum()) {
            return false;
        }
        if (this.isPrimitive() != other.isPrimitive()) {
            return false;
        }
        List<GenericDeclaration> this$subTypes = this.getSubTypes();
        List<GenericDeclaration> other$subTypes = other.getSubTypes();
        if (this$subTypes == null ? other$subTypes != null : !((Object)this$subTypes).equals(other$subTypes)) {
            return false;
        }
        Class<?> this$type = this.getType();
        Class<?> other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnum() ? 79 : 97);
        result = result * 59 + (this.isPrimitive() ? 79 : 97);
        List<GenericDeclaration> $subTypes = this.getSubTypes();
        result = result * 59 + ($subTypes == null ? 43 : ((Object)$subTypes).hashCode());
        Class<?> $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }
}

