/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.platform.paper.worldborderapi;

import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import tr.com.infumia.infumialib.platform.paper.worldborderapi.EarthBorder;
import tr.com.infumia.infumialib.platform.paper.worldborderapi.Position;
import tr.com.infumia.infumialib.platform.paper.worldborderapi.WorldBorderAction;

public interface Border {
    @NotNull
    public EarthBorder get(@NotNull Player var1);

    @NotNull
    public EarthBorder get(@NotNull World var1);

    public void resetWorldBorderToGlobal(@NotNull Player var1);

    public void sendRedScreenForSeconds(@NotNull Player var1, long var2, @NotNull Plugin var4);

    public void set(@NotNull Player var1, double var2);

    public void set(@NotNull Player var1, double var2, @NotNull Vector var4);

    public void set(@NotNull Player var1, double var2, @NotNull Location var4);

    public void set(@NotNull Player var1, double var2, @NotNull Position var4);

    public void set(@NotNull Player var1, double var2, long var4);

    public void set(@NotNull Player var1, double var2, long var4, TimeUnit var6);

    public static abstract class Base
    implements Border {
        @Override
        public final void resetWorldBorderToGlobal(@NotNull Player player) {
            this.get(player.getWorld()).send(player, WorldBorderAction.INITIALIZE);
        }

        @Override
        public final void sendRedScreenForSeconds(@NotNull Player player, long timeSeconds, @NotNull Plugin plugin) {
            EarthBorder border = this.get(player);
            border.warningDistanceInBlocks((int)border.size());
            border.send(player, WorldBorderAction.SET_WARNING_BLOCKS);
            Bukkit.getScheduler().runTaskLater(plugin, () -> {
                border.warningDistanceInBlocks(0);
                border.send(player, WorldBorderAction.SET_WARNING_BLOCKS);
            }, timeSeconds * 20L);
        }

        @Override
        public final void set(@NotNull Player player, double size) {
            this.set(player, size, player.getWorld().getSpawnLocation());
        }

        @Override
        public final void set(@NotNull Player player, double size, @NotNull Vector vector) {
            this.set(player, size, Position.of(vector));
        }

        @Override
        public final void set(@NotNull Player player, double size, @NotNull Location location) {
            this.set(player, size, Position.of(location));
        }

        @Override
        public final void set(@NotNull Player player, double size, @NotNull Position position) {
            EarthBorder border = this.get(player);
            border.size(size);
            border.center(position);
            border.send(player, WorldBorderAction.SET_SIZE);
            border.send(player, WorldBorderAction.SET_CENTER);
        }

        @Override
        public final void set(@NotNull Player player, double size, long milliSeconds) {
            EarthBorder border = this.get(player);
            border.lerp(border.size(), size, milliSeconds);
            border.send(player, WorldBorderAction.LERP_SIZE);
        }

        @Override
        public final void set(@NotNull Player player, double size, long time, TimeUnit timeUnit) {
            this.set(player, size, timeUnit.toMillis(time));
        }
    }
}

