/*
 * Decompiled with CFR 0.152.
 */
package tr.com.infumia.infumialib.platform.paper.bukkititembuilder;

import com.cryptomorin.xseries.XItemStack;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.World;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.MapMeta;
import org.bukkit.map.MapView;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tr.com.infumia.infumialib.platform.paper.bukkititembuilder.Builder;
import tr.com.infumia.infumialib.platform.paper.bukkititembuilder.ItemStackBuilder;
import tr.com.infumia.infumialib.transformer.TransformedData;

public final class MapItemBuilder
extends Builder<MapItemBuilder, MapMeta> {
    private static final Deserializer DESERIALIZER = new Deserializer();

    MapItemBuilder(@NotNull MapMeta itemMeta, @NotNull ItemStack itemStack) {
        super(itemMeta, itemStack);
    }

    @NotNull
    public static MapItemBuilder from(@NotNull MapMeta itemMeta, @NotNull ItemStack itemStack) {
        return new MapItemBuilder(itemMeta, itemStack);
    }

    @NotNull
    public static MapItemBuilder from(@NotNull TransformedData data) {
        return MapItemBuilder.getDeserializer().apply(data).orElseThrow(() -> new IllegalArgumentException(String.format("The given data is incorrect!\n%s", data)));
    }

    @NotNull
    public static Deserializer getDeserializer() {
        return DESERIALIZER;
    }

    @Override
    @NotNull
    public MapItemBuilder getSelf() {
        return this;
    }

    @Override
    public void serialize(@NotNull TransformedData data) {
        super.serialize(data);
        TransformedData map = data.copy();
        MapMeta itemMeta = (MapMeta)this.getItemMeta();
        map.add("scaling", itemMeta.isScaling(), Boolean.TYPE);
        if (Builder.VERSION >= 11) {
            Color color;
            if (itemMeta.hasLocationName()) {
                map.add("location", itemMeta.getLocationName(), String.class);
            }
            if ((color = itemMeta.getColor()) != null) {
                map.add("color", String.format("%d, %d, %d", color.getRed(), color.getGreen(), color.getBlue()), String.class);
            }
        }
        if (Builder.VERSION >= 13) {
            map.add("map-id", itemMeta.getMapId(), Integer.TYPE);
        }
        if (Builder.VERSION >= 14) {
            MapView mapView = itemMeta.getMapView();
            if (itemMeta.hasMapView() && mapView != null) {
                TransformedData view = map.copy();
                view.add("scale", mapView.getScale().toString(), String.class);
                World world = mapView.getWorld();
                if (world != null) {
                    view.add("world", world.getName(), String.class);
                }
                view.add("locked", mapView.isLocked(), Boolean.TYPE);
                view.add("tracking-position", mapView.isTrackingPosition(), Boolean.TYPE);
                view.add("unlimited-tracking", mapView.isUnlimitedTracking(), Boolean.TYPE);
                TransformedData center = view.copy();
                center.add("x", mapView.getCenterX(), Integer.TYPE);
                center.add("z", mapView.getCenterZ(), Integer.TYPE);
                view.add("center", center);
                map.add("view", view);
            }
        }
        data.add("map", map);
    }

    @NotNull
    public MapItemBuilder setColor(@Nullable Color color) {
        if (Builder.VERSION >= 11) {
            ((MapMeta)this.getItemMeta()).setColor(color);
        }
        return this.getSelf();
    }

    @NotNull
    public MapItemBuilder setLocationName(@Nullable String name) {
        if (Builder.VERSION >= 11) {
            ((MapMeta)this.getItemMeta()).setLocationName(name);
        }
        return this.getSelf();
    }

    @Deprecated
    @NotNull
    public MapItemBuilder setMapId(int id) {
        if (Builder.VERSION >= 13) {
            ((MapMeta)this.getItemMeta()).setMapId(id);
        }
        return this.getSelf();
    }

    @NotNull
    public MapItemBuilder setMapView(@NotNull MapView mapView) {
        if (Builder.VERSION >= 14) {
            ((MapMeta)this.getItemMeta()).setMapView(mapView);
        }
        return this.getSelf();
    }

    @NotNull
    public MapItemBuilder setScaling(boolean scaling) {
        ((MapMeta)this.getItemMeta()).setScaling(scaling);
        return this.getSelf();
    }

    public static final class Deserializer
    implements Function<TransformedData, Optional<MapItemBuilder>> {
        @Override
        @NotNull
        public Optional<MapItemBuilder> apply(@NotNull TransformedData data) {
            Optional<ItemStack> itemStack = Builder.getItemStackDeserializer().apply(data);
            if (itemStack.isEmpty()) {
                return Optional.empty();
            }
            MapItemBuilder builder = ItemStackBuilder.from(itemStack.get()).asMap();
            data.getAsMap("map", String.class, Object.class).ifPresent(mapSection -> {
                TransformedData copy = data.copy((Map<String, Object>)mapSection);
                Boolean scaling = copy.get("scaling", Boolean.TYPE).orElse(false);
                builder.setScaling(scaling);
                if (Builder.VERSION >= 11) {
                    copy.get("location", String.class).ifPresent(builder::setLocationName);
                    copy.get("color", String.class).ifPresent(s -> builder.setColor(XItemStack.parseColor((String)s)));
                }
                if (Builder.VERSION >= 13) {
                    copy.get("map-id", Integer.TYPE).ifPresent(builder::setMapId);
                }
                if (Builder.VERSION >= 14) {
                    copy.getAsMap("view", String.class, Object.class).ifPresent(map -> {
                        TransformedData copyCopy = copy.copy((Map<String, Object>)map);
                        copyCopy.get("world", String.class).flatMap(worldName -> Optional.ofNullable(Bukkit.getWorld((String)worldName))).ifPresent(world -> {
                            MapView.Scale scale;
                            Optional<String> scaleOptional = copyCopy.get("scale", String.class);
                            Boolean locked = copyCopy.get("locked", Boolean.TYPE).orElse(false);
                            Boolean trackingPosition = copyCopy.get("tracking-position", Boolean.TYPE).orElse(false);
                            Boolean unlimitedTracking = copyCopy.get("unlimited-tracking", Boolean.TYPE).orElse(false);
                            MapView mapView = Bukkit.createMap((World)world);
                            mapView.setWorld(world);
                            try {
                                scale = scaleOptional.map(MapView.Scale::valueOf).orElse(MapView.Scale.NORMAL);
                            }
                            catch (Exception e) {
                                scale = MapView.Scale.NORMAL;
                            }
                            mapView.setScale(scale);
                            mapView.setLocked(locked.booleanValue());
                            mapView.setTrackingPosition(trackingPosition.booleanValue());
                            mapView.setUnlimitedTracking(unlimitedTracking.booleanValue());
                            Map center = copyCopy.getAsMap("center", String.class, Object.class).orElse(new HashMap());
                            TransformedData copyCopyCopy = copyCopy.copy(center);
                            Integer x = copyCopyCopy.get("x", Integer.TYPE).orElse(0);
                            Integer z = copyCopyCopy.get("z", Integer.TYPE).orElse(0);
                            mapView.setCenterX(x.intValue());
                            mapView.setCenterZ(z.intValue());
                            builder.setMapView(mapView);
                        });
                    });
                }
            });
            return Optional.of(Builder.getItemMetaDeserializer(builder).apply(data));
        }
    }
}

